/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

@MythicCondition(author="Ashijin", name="blockType", aliases={}, description="Tests the material type present at the target location")
public class BlockTypeCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="types", aliases={"type", "t"}, description="A list of materials to check")
    private Set<Material> types = new HashSet<Material>();

    public BlockTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String b = mlc.getString(new String[]{"types", "type", "t"}, "DIRT", this.conditionVar);
        for (String s2 : b.split(",")) {
            try {
                this.types.add(Material.valueOf((String)s2.toUpperCase()));
            }
            catch (IllegalArgumentException ex) {
                MythicLogger.errorConditionConfig(this, mlc, "'" + s2 + "' is not a valid material.");
            }
        }
    }

    @Override
    public boolean check(AbstractLocation l) {
        return this.types.contains(BukkitAdapter.adapt(l).getBlock().getType());
    }
}

