/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import java.util.Optional;

@MythicCondition(author="Ashijin", name="samefaction", aliases={"factionsame"}, version="4.9", description="Tests if the target is in the same faction as the caster")
public class FactionSameCondition
extends SkillCondition
implements IEntityComparisonCondition {
    public FactionSameCondition(String line, MythicLineConfig mlc) {
        super(line);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        String f1 = this.getFaction(entity);
        String f2 = this.getFaction(target);
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "SameFaction {0} == {1}", f1, f2);
        return f1.equals(f2);
    }

    private String getFaction(AbstractEntity entity) {
        ActiveMob am;
        Optional<String> maybeFaction;
        String faction = entity.isPlayer() ? ((maybeFaction = FactionSameCondition.getPlugin().getPlayerManager().getFactionProvider().getFaction(entity.asPlayer())).isPresent() ? maybeFaction.get() : "NONE") : ((am = FactionSameCondition.getPlugin().getMobManager().getMythicMobInstance(entity)) == null ? "NONE" : (am.getFaction() == null ? "NONE" : am.getFaction()));
        return faction;
    }
}

