/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="foodSaturation", aliases={"hungerSaturation"}, description="Matches the target's food saturation level")
public class FoodSaturationCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="amount", aliases={"a"}, description="The food range to check for")
    private RangedDouble amount;

    public FoodSaturationCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.amount = new RangedDouble(mlc.getString(new String[]{"amount", "a", "food", "f", "saturation", "s"}, "0", this.conditionVar));
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (entity.isPlayer()) {
            double v = entity.asPlayer().getFoodSaturation();
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking FoodSaturation: {0} vs {1}", v, this.amount.toString());
            return this.amount.equals(v);
        }
        return false;
    }
}

