/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="lightLevel", aliases={}, description="Tests the light level at the target location")
public class LightLevelCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="level", aliases={"l"}, description="The level range to match")
    private RangedDouble level;

    public LightLevelCondition(String line, MythicLineConfig mlc) {
        super(line);
        String k = mlc.getString(new String[]{"level", "l"}, "0", this.conditionVar);
        this.level = new RangedDouble(k);
    }

    @Override
    public boolean check(AbstractLocation l) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking LightLevel: {0} vs {1}", l.getWorld().getLightLevel(l), this.level.toString());
        return this.level.equals(l.getWorld().getLightLevel(l));
    }
}

