/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="localdifficulty", aliases={}, description="Tests the difficulty scale at the target location")
public class LocalDifficultyCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="difficulty", aliases={"diff", "d"}, description="The difficulty range to check")
    private RangedDouble difficulty;

    public LocalDifficultyCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.difficulty = new RangedDouble(mlc.getString(new String[]{"difficulty", "diff", "d"}, this.conditionVar, new String[0]));
    }

    @Override
    public boolean check(AbstractLocation target) {
        float diff = LocalDifficultyCondition.getPlugin().getVolatileCodeHandler().getWorldHandler().getDifficultyScale(target);
        return this.difficulty.equals(Float.valueOf(diff));
    }
}

