/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import java.util.HashSet;
import java.util.Set;

@MythicCondition(author="Ashijin", name="lunarPhase", aliases={}, description="Checks the target world's lunar phase")
public class LunarPhaseCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="phases", aliases={"phase", "p"}, description="A list of lunar phases")
    private Set<Integer> phases = new HashSet<Integer>();

    public LunarPhaseCondition(String line, MythicLineConfig mlc) {
        super(line);
        String[] split;
        String phase = mlc.getString(new String[]{"phases", "phase", "p"}, "0", this.conditionVar);
        for (String s2 : split = phase.split(",")) {
            this.phases.add(Integer.valueOf(s2));
        }
    }

    @Override
    public boolean check(AbstractLocation l) {
        int phase = (int)(l.getWorld().getFullTime() / 24000L % 8L);
        return this.phases.contains(phase);
    }
}

