/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="mobsinchunk", aliases={}, description="Matches a range to how many mobs are in the target location's chunk")
public class MobsInChunkCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="amount", aliases={"a"}, description="The number range to match")
    private RangedDouble amount;

    public MobsInChunkCondition(String line, MythicLineConfig mlc) {
        super(line);
        String k = mlc.getString(new String[]{"amount", "a"}, "0", this.conditionVar);
        this.amount = new RangedDouble(k);
    }

    @Override
    public boolean check(AbstractLocation l) {
        return this.amount.equals(BukkitAdapter.adapt(l).getChunk().getEntities().length);
    }
}

