/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;
import java.util.HashSet;

@MythicCondition(author="Ashijin", name="mobsinradius", aliases={}, description="Matches a range to how many mobs are in the given radius")
public class MobsInRadiusCondition
extends SkillCondition
implements ISkillMetaCondition {
    private HashSet<MythicMob> mmTypes = new HashSet();
    private HashSet<BukkitEntityType> meTypes = new HashSet();
    @MythicField(name="amount", aliases={"a"}, description="The number range to match")
    private RangedDouble amount;
    @MythicField(name="radius", aliases={"r"}, description="The radius to check")
    private PlaceholderDouble radius;

    public MobsInRadiusCondition(String line, MythicLineConfig mlc) {
        super(line);
        String k = mlc.getString(new String[]{"amount", "a"}, "1", this.conditionVar);
        this.amount = new RangedDouble(k);
        this.radius = mlc.getPlaceholderDouble(new String[]{"radius", "r"}, "5", this.conditionVar);
        String types = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        String[] ss = types.split(",");
        Schedulers.sync().runLater(() -> {
            for (String s2 : ss) {
                MythicMob mm3 = MobsInRadiusCondition.getPlugin().getMobManager().getMythicMob(s2);
                if (mm3 != null) {
                    this.mmTypes.add(mm3);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    this.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorConditionConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "@MIR targeter loaded targeting " + (this.meTypes.size() + this.mmTypes.size()) + " types", new Object[0]);
        }, 5L);
    }

    @Override
    public boolean check(SkillMetadata meta) {
        SkillCaster caster = meta.getCaster();
        AbstractLocation l = caster.getEntity().getLocation();
        double radiusSq = Math.pow(this.radius.get(meta, meta.getCaster().getEntity()), 2.0);
        int found = 0;
        block0: for (AbstractEntity p : MobsInRadiusCondition.getPlugin().getEntityManager().getLivingEntities(l.getWorld())) {
            if (p.getUniqueId().equals(caster.getEntity().getUniqueId()) || !p.getWorld().equals(caster.getEntity().getWorld()) || !(caster.getEntity().getLocation().distanceSquared(p.getLocation()) <= radiusSq)) continue;
            ActiveMob amx = MobsInRadiusCondition.getPlugin().getMobManager().getMythicMobInstance(p);
            if (amx != null) {
                if (!this.mmTypes.contains(amx.getType())) continue;
                ++found;
                amx = null;
                continue;
            }
            for (BukkitEntityType me : this.meTypes) {
                if (!me.compare(p.getBukkitEntity())) continue;
                ++found;
                continue block0;
            }
        }
        return this.amount.equals(found);
    }
}

