/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ICasterCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;

@MythicCondition(author="Ashijin", name="offGCD", aliases={}, description="Checks if the target mob has an active Global Cooldown")
public class OffGCDCondition
extends SkillCondition
implements ICasterCondition,
IEntityCondition {
    public OffGCDCondition(String line, MythicLineConfig mlc) {
        super(line);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (MythicMobs.inst().getMobManager().isActiveMob(entity)) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(entity);
            return am.getGlobalCooldown() <= 0;
        }
        return false;
    }

    @Override
    public boolean check(SkillCaster caster) {
        return caster.getGlobalCooldown() <= 0;
    }
}

