/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import org.bukkit.Location;
import org.bukkit.entity.Player;

@MythicCondition(author="Ashijin", name="playerWithin", aliases={"playerswithin"}, description="Checks if any players are within a radius of the target")
public class PlayerWithinCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="distance", aliases={"d"}, description="The radius to check in")
    private double distance;

    public PlayerWithinCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.distance = Math.pow(Double.valueOf(mlc.getString(new String[]{"distance", "d"}, "0", this.conditionVar)), 2.0);
    }

    @Override
    public boolean check(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        for (Player p : l.getWorld().getPlayers()) {
            if (!(l.distanceSquared(p.getLocation()) <= this.distance)) continue;
            return true;
        }
        return false;
    }
}

