/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.Patterns;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;

@MythicCondition(author="Ashijin", name="stance", aliases={}, description="Checks the stance of the target mob")
public class StanceCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="stance", aliases={"s"}, description="The stance to match")
    private final String stance;
    @MythicField(name="strict", aliases={"str"}, description="Whether to match exactly. Defaults to false.")
    private final boolean strictMatch;
    private final boolean parse;

    public StanceCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.stance = mlc.getString(new String[]{"stance", "s"}, "DEFAULT", this.conditionVar);
        this.strictMatch = mlc.getBoolean(new String[]{"strict", "str"}, false);
        this.parse = mlc.getBoolean(new String[]{"parse", "p"}, false);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (MythicMobs.inst().getMobManager().isActiveMob(entity)) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(entity);
            if (this.parse) {
                Patterns.CompilePatterns();
            }
            return this.strictMatch ? am.getStance().equals(this.stance) : am.getStance().contains(this.stance);
        }
        return false;
    }
}

