/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedInt;

@MythicCondition(author="Ashijin", name="worldtime", aliases={}, description="Matches a range against the target location's world's time.")
public class WorldTimeCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="time", aliases={"t"}, description="A range of time to check")
    private PlaceholderString time;

    public WorldTimeCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.time = mlc.getPlaceholderString(new String[]{"time", "t"}, "0", this.conditionVar);
    }

    @Override
    public boolean check(AbstractLocation l) {
        long time = BukkitAdapter.adapt(l.getWorld()).getTime();
        RangedInt compare = new RangedInt(this.time.get());
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking Worldtime: {0} vs {1}", time, compare.toString());
        return compare.equals(time);
    }
}

