/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.Location;

@MythicMechanic(author="Ashijin", name="blockphysics", version="4.11", aliases={"bphysics"}, description="Force a block physics update at the target location")
public class BlockPhysicsMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    public BlockPhysicsMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        BlockPhysicsMechanic.getPlugin().getVolatileCodeHandler().getBlockHandler().applyPhysics(l.getBlock());
    }
}

