/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="command", aliases={"cmd"}, description="Executes a command")
public class CommandMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
INoTargetSkill {
    protected PlaceholderString command;
    protected boolean asCaster;
    protected boolean asTarget;
    protected boolean requireTarget;
    protected boolean asOperator;

    public CommandMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.command = PlaceholderString.of(mlc.getString(new String[]{"command", "cmd", "c"}));
        this.asCaster = mlc.getBoolean(new String[]{"ascaster", "caster", "ac", "sudo", "asmob"}, false);
        this.asTarget = mlc.getBoolean(new String[]{"astarget", "target", "at", "sudotarget"}, false);
        this.requireTarget = mlc.getBoolean(new String[]{"requiretarget", "rt"}, this.asTarget);
        this.asOperator = mlc.getBoolean(new String[]{"asop", "op"}, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        String parsedCommand = this.command.get(data, target);
        if (this.asCaster) {
            if (data.getCaster().getEntity().isPlayer()) {
                Player player = (Player)BukkitAdapter.adapt(data.getCaster().getEntity());
                if (this.asOperator) {
                    boolean op = player.isOp();
                    try {
                        player.setOp(true);
                        player.performCommand(parsedCommand);
                    }
                    finally {
                        player.setOp(op);
                    }
                } else {
                    player.performCommand(parsedCommand);
                }
            } else {
                CommandMechanic.getPlugin().server().dispatchCommand("minecraft:execute " + data.getCaster().getEntity().getUniqueId() + " ~ ~ ~ " + parsedCommand);
            }
        } else if (this.asTarget) {
            if (target.isPlayer()) {
                Player player = (Player)BukkitAdapter.adapt(target);
                if (this.asOperator) {
                    boolean op = player.isOp();
                    try {
                        player.setOp(true);
                        player.performCommand(parsedCommand);
                    }
                    finally {
                        player.setOp(op);
                    }
                } else {
                    player.performCommand(parsedCommand);
                }
            } else {
                CommandMechanic.getPlugin().server().dispatchCommand("minecraft:execute " + target.getUniqueId() + " ~ ~ ~ " + parsedCommand);
            }
        } else {
            CommandMechanic.getPlugin().server().dispatchCommand(parsedCommand);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cast(SkillMetadata data) {
        if (this.requireTarget) {
            return false;
        }
        String parsedCommand = this.command.get(data);
        if (this.asCaster) {
            if (data.getCaster().getEntity().isPlayer()) {
                Player player = (Player)BukkitAdapter.adapt(data.getCaster().getEntity());
                if (this.asOperator) {
                    boolean op = player.isOp();
                    try {
                        player.setOp(true);
                        player.performCommand(parsedCommand);
                    }
                    finally {
                        player.setOp(op);
                    }
                } else {
                    player.performCommand(parsedCommand);
                }
            } else {
                CommandMechanic.getPlugin().server().dispatchCommand("minecraft:execute " + data.getCaster().getEntity().getUniqueId() + " ~ ~ ~ " + parsedCommand);
            }
        } else {
            CommandMechanic.getPlugin().server().dispatchCommand(parsedCommand);
        }
        return true;
    }
}

