/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="currencyTake", aliases={"takeCurrency"}, description="Removes an amount of vault currency")
public class CurrencyTakeMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderDouble amount;

    public CurrencyTakeMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "a"}, 0.0, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        if (CurrencyTakeMechanic.getPlugin().getCompatibility().getVault().isPresent()) {
            CurrencyTakeMechanic.getPlugin().getCompatibility().getVault().get().takeMoney(target.asPlayer(), this.amount.get(data, target));
        } else {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not run TakeCurrency mechanic: Vault not found.");
        }
        return false;
    }
}

