/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.damage.DamagingMechanic;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="damagePercent", aliases={"percentDamage"}, description="Deals a percentage of the target's health in damage")
public class DamagePercentMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble percent;
    protected boolean currentHealth;

    public DamagePercentMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.percent = PlaceholderDouble.of(mlc.getString(new String[]{"percent", "p"}, "0.1", new String[0]));
        this.currentHealth = mlc.getBoolean(new String[]{"current", "ch", "c"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        double damage = this.currentHealth ? target.getHealth() * this.percent.get(data, target) * (double)this.power : target.getMaxHealth() * this.percent.get(data, target) * (double)this.power;
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ DamagePercentMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
        this.doDamage(data.getCaster(), target, damage);
        return true;
    }
}

