/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.drops.LootBag;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="giveitem", aliases={"give", "giveitems", "itemgive"}, description="Gives the target an item or droptable")
public class GiveItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private DropTable dropTable;

    public GiveItemMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        String itemString = mlc.getString(new String[]{"items", "item", "i"});
        Optional<DropTable> maybeTable = GiveItemMechanic.getPlugin().getDropManager().getDropTable(itemString);
        if (maybeTable.isPresent()) {
            this.dropTable = maybeTable.get();
            return;
        }
        if (itemString.startsWith("\"")) {
            try {
                itemString = itemString.substring(1, itemString.length() - 1);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
            }
            itemString = SkillString.parseMessageSpecialChars(itemString);
        }
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(itemString.split(",")));
        this.dropTable = new DropTable("DropItemMechanic", "DropItemMechanic", items);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        LootBag loot = this.dropTable.generate(new DropMetadata(data.getCaster(), data.getCaster().getEntity()));
        if (target.isPlayer()) {
            loot.give(target.asPlayer(), false);
        }
        return true;
    }
}

