/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="metaskill", aliases={"skill", "meta"}, description="Executes a metaskill")
public class MetaSkillMechanic
extends SkillMechanic
implements IMetaSkill {
    protected String skillName;
    protected Optional<Skill> metaskill;

    public MetaSkillMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.target_creative = true;
        this.skillName = mlc.getString(new String[]{"skill", "s", "meta", "m", "mechanics", "$", "()"});
        MetaSkillMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loading MetaSkillMechanic -> {0}", this.skillName);
            this.metaskill = MetaSkillMechanic.getPlugin().getSkillManager().getSkill(this.skillName);
            if (!this.metaskill.isPresent()) {
                MythicLogger.errorMechanicConfig(this, mlc, "Could not find MetaSkill " + this.skillName);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded MetaSkillMechanic successfully", new Object[0]);
            }
        });
    }

    public MetaSkillMechanic(String skill, String skillName, MythicLineConfig mlc) {
        super(skill, mlc);
        this.target_creative = true;
        this.skillName = skillName;
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loading MetaSkillMechanic -> {0}", this.skillName);
            this.metaskill = MythicMobs.inst().getSkillManager().getSkill(this.skillName);
            if (!this.metaskill.isPresent()) {
                MythicLogger.errorMechanicConfig(this, mlc, "Could not find MetaSkill " + this.skillName);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded MetaSkillMechanic successfully", new Object[0]);
            }
        });
    }

    public Skill getSkill() {
        return this.metaskill.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean cast(SkillMetadata data) {
        if (!this.metaskill.isPresent()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MetaSkill {0} was not found on load", this.skillName);
            return true;
        }
        Skill ms = this.metaskill.get();
        if (!ms.isUsable(data)) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MetaSkill {0} is currently unusable", this.skillName);
            return false;
        }
        if (ConfigManager.debugLevel > 0) {
            if (data.getEntityTargets() != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaSkill (et: {0}) -> {1}", data.getEntityTargets().size(), this.skillName);
            } else if (data.getLocationTargets() != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaSkill (lt: {0}) -> {1}", data.getLocationTargets().size(), this.skillName);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaSkill (t: 0) -> {0}", this.skillName);
            }
        }
        if (this.forceSync && data.getIsAsync()) {
            data.setIsAsync(false);
            Scheduler.runSync(() -> {
                data.setIsAsync(false);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Skill {0} Sync from MetaSkillMechanic", this.skillName);
                ms.execute(data);
            });
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Skill {0} Async from MetaSkillMechanic", this.skillName);
        ms.execute(data);
        return true;
    }
}

