/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="oxygen", version="4.11", description="Gives the target player oxygen")
public class OxygenMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderInt amount;

    public OxygenMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || !target.isPlayer()) {
            return false;
        }
        int currentOxygen = target.asPlayer().getRemainingAir();
        int oxygen = currentOxygen + this.amount.get(data, target);
        if (oxygen >= target.asPlayer().getMaximumAir()) {
            target.asPlayer().setRemainingAir(target.asPlayer().getMaximumAir());
        } else {
            target.asPlayer().setRemainingAir(oxygen);
        }
        return true;
    }
}

