/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class ShieldMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected float amount = 1.0f;
    protected float maxShield = 1.0f;

    public ShieldMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = (float)mlc.getDouble(new String[]{"amount", "a"}, 1.0);
        this.maxShield = mlc.getFloat(new String[]{"maxabsorb", "maxshield", "ma", "ms"}, this.amount);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return false;
        }
        double absorb = MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().getEntityAbsorptionHearts(target) + this.amount;
        if (absorb < (double)this.maxShield) {
            MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().setEntityAbsorptionHearts(target, (float)absorb);
        }
        return true;
    }
}

