/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="shootfireball", aliases={"shootprojetile"}, description="Shoots a projectile at the target location")
public class ShootFireballMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected FireballType type;
    protected float yield;
    protected float velocity;
    protected int fireticks;
    protected boolean incendiary;
    protected boolean playsound;
    protected boolean charged = false;
    protected BukkitItemStack itemType = null;

    public ShootFireballMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.yield = mlc.getFloat(new String[]{"yield", "strength", "y", "s"}, 1.0f);
        this.velocity = mlc.getFloat(new String[]{"velocity", "v"}, 1.0f);
        this.fireticks = mlc.getInteger(new String[]{"fireticks", "ft"}, 0);
        this.incendiary = mlc.getBoolean(new String[]{"incendiary", "i"}, false);
        this.playsound = mlc.getBoolean(new String[]{"playsound", "ps"}, false);
        this.charged = mlc.getBoolean(new String[]{"charged", "c"}, false);
        String strItem = mlc.getString(new String[]{"item", "material"}, "BLAZE_POWDER", new String[0]);
        this.itemType = new BukkitItemStack(strItem);
        FireballType def = FireballType.NORMAL;
        if (mlc.getBoolean(new String[]{"smallfireball", "small", "sml"}, false)) {
            def = FireballType.SMALL;
        }
        String strType = mlc.getString(new String[]{"type", "t"}, def.toString(), new String[0]);
        try {
            this.type = FireballType.valueOf(strType.toUpperCase());
        }
        catch (Error | Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid Fireball type supplied");
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        SkillAdapter.get().shootFireball(data.getCaster(), this.type, target, this.velocity, this.yield, this.incendiary, this.fireticks, this.playsound, this.charged, this.itemType);
        return true;
    }

    public static enum FireballType {
        NORMAL,
        SMALL,
        LARGE,
        WITHER,
        DRAGON,
        ITEM;

    }
}

