/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.WitherSkull;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ShootSkullMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float yield;
    protected boolean playsound;

    public ShootSkullMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.yield = mlc.getFloat("yield", 1.0f);
        this.yield = mlc.getFloat("strength", this.yield);
        this.yield = mlc.getFloat("y", this.yield);
        this.yield = mlc.getFloat("s", this.yield);
        this.playsound = mlc.getBoolean("playsound", false);
        this.playsound = mlc.getBoolean("ps", this.playsound);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        WitherSkull fireball;
        Entity l = BukkitAdapter.adapt(data.getCaster().getEntity());
        Location t = BukkitAdapter.adapt(target);
        if (l instanceof Creature && ((Creature)l).getTarget() == target) {
            fireball = (WitherSkull)((LivingEntity)l).launchProjectile(WitherSkull.class);
        } else {
            Vector facing = t.toVector().subtract(l.getLocation().toVector()).normalize();
            Location loc = l.getLocation().clone();
            double yaw = Math.toDegrees(Math.atan2(-facing.getX(), facing.getZ()));
            double pitch = Math.toDegrees(-Math.asin(facing.getY()));
            loc.setYaw((float)yaw);
            loc.setPitch((float)pitch);
            loc.add(facing.multiply(2));
            fireball = (WitherSkull)l.getLocation().getWorld().spawn(loc, WitherSkull.class);
        }
        if (this.playsound) {
            l.getWorld().playEffect(l.getLocation(), Effect.GHAST_SHOOT, 0);
        }
        fireball.setBounce(false);
        fireball.setYield(this.yield);
        if (l instanceof LivingEntity) {
            fireball.setShooter((ProjectileSource)((LivingEntity)l));
        }
        return true;
    }
}

