/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.Optional;

public class SignalMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString signal;

    public SignalMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.signal = mlc.getPlaceholderString(new String[]{"signal", "s"}, "ping", new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Optional<ActiveMob> maybeMob = SignalMechanic.getPlugin().getMobManager().getActiveMob(target.getUniqueId());
        if (maybeMob.isPresent()) {
            String signal = this.signal.get(data, target);
            ActiveMob at = maybeMob.get();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Sending signal {0} to mob {1}", signal, at.getUniqueId());
            at.signalMob(data.getCaster().getEntity(), signal);
            return true;
        }
        return false;
    }
}

