/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillAudience;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.audience.WorldAudience;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="effect:sound", aliases={"sound", "s", "e:sound", "e:s"}, description="Plays a sound at the target location")
public class SoundEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private PlaceholderString sound;
    private SkillAudience audience;
    private float pitch;
    private float volume;
    private double radiusSq;
    private SoundCategory soundCategory = null;

    public SoundEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.sound = mlc.getPlaceholderString(new String[]{"sound", "s"}, "entity.zombie.attack_iron_door", new String[0]);
        this.audience = mlc.getAudience("audience", "world");
        this.pitch = mlc.getFloat(new String[]{"pitch", "p"}, 1.0f);
        this.volume = mlc.getFloat(new String[]{"volume", "v"}, 1.0f);
        this.radiusSq = mlc.getDouble(new String[]{"radius", "r"}, (double)(this.volume * 16.0f));
        this.radiusSq = Math.pow(this.radiusSq, 2.0);
        String soundCategoryString = mlc.getString(new String[]{"soundcategory", "category", "sc"}, null, new String[0]);
        if (soundCategoryString != null) {
            for (SoundCategory sc : SoundCategory.values()) {
                if (!soundCategoryString.toUpperCase().equals(sc.toString())) continue;
                this.soundCategory = sc;
                break;
            }
            if (this.soundCategory == null) {
                MythicLogger.errorMechanicConfig(this, mlc, "Invalid SoundCategory specified");
            }
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        HashSet<AbstractEntity> audience = this.audience instanceof WorldAudience ? null : this.audience.get(data, null);
        this.playSound(data, target, audience);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        HashSet<AbstractEntity> audience = this.audience instanceof WorldAudience ? null : this.audience.get(data, target);
        this.playSound(data, target.getLocation(), audience);
        return true;
    }

    protected void playSound(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        Location l = BukkitAdapter.adapt(target);
        if (audience == null) {
            l.getWorld().playSound(l, this.sound.get(data), this.soundCategory == null ? SoundCategory.MASTER : this.soundCategory, this.volume, this.pitch);
        } else {
            for (AbstractEntity entity : audience) {
                ((Player)entity.getBukkitEntity()).playSound(l, this.sound.get(data), this.soundCategory == null ? SoundCategory.MASTER : this.soundCategory, this.volume, this.pitch);
            }
        }
    }
}

