/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.variables.Variable;
import io.lumine.xikage.mythicmobs.skills.variables.VariableMechanic;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.skills.variables.types.FloatVariable;
import io.lumine.xikage.mythicmobs.skills.variables.types.IntegerVariable;

public class VariableSubtractMechanic
extends VariableMechanic
implements ITargetedEntitySkill {
    protected float amount;

    public VariableSubtractMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.amount = mlc.getFloat(new String[]{"amount", "a"}, 0.0f);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        VariableRegistry variables = VariableSubtractMechanic.getVariableManager().getRegistry(this.scope, data, target);
        Variable var = variables.get(this.key);
        if (var == null) {
            return false;
        }
        if (var instanceof IntegerVariable) {
            int val = ((IntegerVariable)var).getValue();
            ((IntegerVariable)var).setValue(val - (int)this.amount);
        } else if (var instanceof FloatVariable) {
            float val = ((FloatVariable)var).getValue();
            ((FloatVariable)var).setValue(val - this.amount);
        } else {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not perform math operation on non-numeric variable type");
            return false;
        }
        this.handleDuration(var);
        return true;
    }
}

