/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.placeholders.parsers;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderParser;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.RandomDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.StaticDouble;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderDouble
extends PlaceholderParser {
    public PlaceholderDouble(String string) {
        super(string);
        if (string != null && string.startsWith("=")) {
            this.doMath = true;
        }
    }

    public double get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return new ExpressionBuilder(string).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderString: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return Double.valueOf(string);
    }

    public double get(PlaceholderMeta meta) {
        return this.get(meta, meta == null ? null : meta.getTrigger());
    }

    public double get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    public double get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return new ExpressionBuilder(string).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderString: " + this.strValue);
                ex.printStackTrace();
            }
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException ex) {
            return 1.0;
        }
    }

    public double get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderDouble of(String string) {
        try {
            if (io.lumine.xikage.mythicmobs.utils.numbers.RandomDouble.matches(string)) {
                return new RandomDouble(string);
            }
            if (string.matches("-?\\d+\\.?\\d*")) {
                return new StaticDouble(string);
            }
            if (!MythicMobs.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythicmobs.net.");
                return new StaticDouble("1");
            }
            return new PlaceholderDouble(string);
        }
        catch (Exception exception) {
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticDouble("1");
        }
    }
}

