/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import java.util.HashSet;

public abstract class ILocationSelector
extends SkillTargeter {
    protected double yoffset;

    public ILocationSelector(MythicLineConfig mlc) {
        super(mlc);
        this.yoffset = mlc.getDouble(new String[]{"yoffset", "yo", "y"}, 0.0);
    }

    public abstract HashSet<AbstractLocation> getLocations(SkillMetadata var1);

    public void filter(SkillMetadata data) {
        if (this.targetConditions != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying target conditions", new Object[0]);
            for (SkillCondition mc : this.targetConditions) {
                if (mc.evaluateTargets(data)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return;
            }
        }
        data.getLocationTargets().forEach(t -> {});
    }

    public AbstractLocation mutate(AbstractLocation location) {
        if (this.yoffset != 0.0) {
            location = location.clone().add(0.0, this.yoffset, 0.0);
        }
        return location;
    }
}

