/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="randomThreatTargetLocation", aliases={"RTTL"}, description="Targets the location of a random entity on the caster's threat table")
public class ThreatTableRandomLocationTargeter
extends ILocationSelector {
    public ThreatTableRandomLocationTargeter(MythicLineConfig mlc) {
        super(mlc);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        if (!(data.getCaster() instanceof ActiveMob)) {
            return targets;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        if (am.hasThreatTable()) {
            if (am.getThreatTable().size() == 1) {
                targets.add(am.getThreatTable().getTopThreatHolder().getLocation());
            } else if (am.getThreatTable().size() > 1) {
                int r = Numbers.randomInt(am.getThreatTable().size());
                targets.add(((AbstractEntity)am.getThreatTable().getAllThreatTargets().toArray()[r]).getLocation());
            }
        } else {
            MythicLogger.errorTargeterConfig(this, this.config, "ThreatTable targeters are only available on mobs with Options.UseThreatTable set to True!.");
        }
        return targets;
    }
}

