/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.inventory;

import io.lumine.xikage.mythicmobs.utils.adventure.inventory.Book;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.text.examination.ExaminableProperty;
import io.lumine.xikage.mythicmobs.utils.text.examination.string.StringExaminer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BookImpl
implements Book {
    private final Component title;
    private final Component author;
    private final List<Component> pages;

    BookImpl(@NonNull Component title, @NonNull Component author, @NonNull List<Component> pages) {
        this.title = Objects.requireNonNull(title, "title");
        this.author = Objects.requireNonNull(author, "author");
        this.pages = Collections.unmodifiableList(Objects.requireNonNull(pages, "pages"));
    }

    @Override
    public @NonNull Component title() {
        return this.title;
    }

    @Override
    public @NonNull Book title(@NonNull Component title) {
        return new BookImpl(Objects.requireNonNull(title, "title"), this.author, this.pages);
    }

    @Override
    public @NonNull Component author() {
        return this.author;
    }

    @Override
    public @NonNull Book author(@NonNull Component author) {
        return new BookImpl(this.title, Objects.requireNonNull(author, "author"), this.pages);
    }

    @Override
    public @NonNull List<Component> pages() {
        return this.pages;
    }

    @Override
    public @NonNull Book pages(@NonNull List<Component> pages) {
        return new BookImpl(this.title, this.author, new ArrayList<Component>((Collection)Objects.requireNonNull(pages, "pages")));
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("title", this.title), ExaminableProperty.of("author", this.author), ExaminableProperty.of("pages", this.pages));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BookImpl)) {
            return false;
        }
        BookImpl that = (BookImpl)o;
        return this.title.equals(that.title) && this.author.equals(that.author) && this.pages.equals(that.pages);
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + this.author.hashCode();
        result = 31 * result + this.pages.hashCode();
        return result;
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }

    static final class BuilderImpl
    implements Book.Builder {
        private Component title = Component.empty();
        private Component author = Component.empty();
        private final List<Component> pages = new ArrayList<Component>();

        BuilderImpl() {
        }

        @Override
        public @NonNull Book.Builder title(@NonNull Component title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @Override
        public @NonNull Book.Builder author(@NonNull Component author) {
            this.author = Objects.requireNonNull(author, "author");
            return this;
        }

        @Override
        public @NonNull Book.Builder addPage(@NonNull Component page) {
            this.pages.add(Objects.requireNonNull(page, "page"));
            return this;
        }

        @Override
        public @NonNull Book.Builder pages(@NonNull Collection<Component> pages) {
            this.pages.addAll(Objects.requireNonNull(pages, "pages"));
            return this;
        }

        @Override
        public @NonNull Book.Builder pages(Component ... pages) {
            Collections.addAll(this.pages, pages);
            return this;
        }

        @Override
        public @NonNull Book build() {
            return new BookImpl(this.title, this.author, new ArrayList<Component>(this.pages));
        }
    }
}

