/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.properties.types;

import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyType;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.DoubleProp;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.PositionProp;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import io.lumine.xikage.mythicmobs.utils.serialize.CircularRegion;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;

public class CircularRegionProp
extends PropertyType<CircularRegion> {
    private final PositionProp center;
    private final DoubleProp radius;

    public CircularRegionProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.center = new PositionProp(plugin, file, node + ".Center");
        this.radius = new DoubleProp(plugin, file, node + ".Radius");
    }

    public CircularRegionProp(LuminePlugin plugin, Object file, String node, CircularRegion def) {
        super(plugin, file, node);
        this.center = new PositionProp(plugin, file, node + ".Center", def.getCenter());
        this.radius = new DoubleProp(plugin, file, node + ".Radius", def.getRadius());
    }

    @Override
    protected CircularRegion compute(ConfigurationSection section, String node) {
        return CircularRegion.of((Position)this.center.get(section), (Double)this.radius.get(section));
    }

    @Override
    public void set(String holder, CircularRegion value) {
        if (this.config == null) {
            return;
        }
        this.center.set(holder, value.getCenter());
        this.radius.set(holder, Double.valueOf(value.getRadius()));
    }
}

