/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.serialize;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.xikage.mythicmobs.utils.gson.GsonSerializable;
import io.lumine.xikage.mythicmobs.utils.gson.JsonBuilder;
import io.lumine.xikage.mythicmobs.utils.serialize.Direction;
import io.lumine.xikage.mythicmobs.utils.serialize.Locus;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.World;

public final class Orient
implements GsonSerializable {
    private final Locus locus;
    private final Direction direction;

    public static Orient deserialize(JsonElement element) {
        Locus locus = Locus.deserialize(element);
        Direction direction = Direction.deserialize(element);
        return Orient.of(locus, direction);
    }

    public static Orient of(Locus locus, Direction direction) {
        Objects.requireNonNull(locus, "locus");
        Objects.requireNonNull(direction, "direction");
        return new Orient(locus, direction);
    }

    public static Orient of(Location location) {
        Objects.requireNonNull(location, "location");
        return Orient.of(Locus.of(location), Direction.from(location));
    }

    private Orient(Locus locus, Direction direction) {
        this.locus = locus;
        this.direction = direction;
    }

    public Locus getLocus() {
        return this.locus;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public synchronized Location toLocation(World world) {
        return new Location(world, this.locus.getX(), this.locus.getY(), this.locus.getZ(), this.direction.getYaw(), this.direction.getPitch());
    }

    public Orient add(double x, double y, double z) {
        return this.locus.add(x, y, z).withDirection(this.direction);
    }

    public Orient subtract(double x, double y, double z) {
        return this.locus.subtract(x, y, z).withDirection(this.direction);
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().addAll(this.locus.serialize()).addAll(this.direction.serialize()).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Orient)) {
            return false;
        }
        Orient other = (Orient)o;
        return this.getLocus().equals(other.getLocus()) && this.getDirection().equals(other.getDirection());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLocus().hashCode();
        result = result * 59 + this.getDirection().hashCode();
        return result;
    }

    public String toString() {
        return "Point(locus=" + this.getLocus() + ", direction=" + this.getDirection() + ")";
    }
}

