/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.tasks;

import com.google.common.base.Preconditions;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LoaderUtils;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.timings.Timings;
import io.lumine.xikage.mythicmobs.utils.timingslib.MCTiming;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

@Deprecated
public final class Scheduler {
    private static final Executor SYNC_EXECUTOR = runnable -> Scheduler.bukkit().scheduleSyncDelayedTask((Plugin)LoaderUtils.getPlugin(), runnable);
    private static final Executor BUKKIT_ASYNC_EXECUTOR = runnable -> Scheduler.bukkit().runTaskAsynchronously((Plugin)LoaderUtils.getPlugin(), runnable);
    private static final ExecutorService ASYNC_EXECUTOR = Executors.newCachedThreadPool();
    private static final Consumer<Throwable> EXCEPTION_CONSUMER = throwable -> {
        Log.severe("[SCHEDULER] Exception thrown whilst executing task");
        throwable.printStackTrace();
    };

    private static <T> Supplier<T> wrapSupplier(Supplier<T> supplier) {
        return () -> {
            try (MCTiming t = Timings.get().ofStart("scheduler: " + supplier.getClass().getName());){
                Object t2 = supplier.get();
                return t2;
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                throw new CompletionException(t2);
            }
        };
    }

    private static <T> Supplier<T> wrapCallable(Callable<T> callable) {
        return () -> {
            try (MCTiming t = Timings.get().ofStart("scheduler: " + callable.getClass().getName());){
                Object v = callable.call();
                return v;
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                throw new CompletionException(t2);
            }
        };
    }

    private static Runnable wrapRunnable(Runnable runnable) {
        return () -> {
            try (MCTiming t = Timings.get().ofStart("scheduler: " + runnable.getClass().getName());){
                runnable.run();
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                throw new CompletionException(t2);
            }
        };
    }

    public static synchronized Executor sync() {
        return SYNC_EXECUTOR;
    }

    public static synchronized Executor bukkitAsync() {
        return BUKKIT_ASYNC_EXECUTOR;
    }

    public static synchronized ExecutorService internalAsync() {
        return ASYNC_EXECUTOR;
    }

    public static synchronized Executor async() {
        return LoaderUtils.getPlugin().isEnabled() ? Scheduler.bukkitAsync() : Scheduler.internalAsync();
    }

    public static BukkitScheduler bukkit() {
        return Bukkit.getScheduler();
    }

    public static <T> CompletableFuture<T> supplySync(Supplier<T> supplier) {
        Preconditions.checkNotNull(supplier, "supplier");
        return CompletableFuture.supplyAsync(Scheduler.wrapSupplier(supplier), Scheduler.sync());
    }

    public static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        Preconditions.checkNotNull(supplier, "supplier");
        return CompletableFuture.supplyAsync(Scheduler.wrapSupplier(supplier), Scheduler.async());
    }

    public static <T> CompletableFuture<T> callSync(Callable<T> callable) {
        Preconditions.checkNotNull(callable, "callable");
        return CompletableFuture.supplyAsync(Scheduler.wrapCallable(callable), Scheduler.sync());
    }

    public static <T> CompletableFuture<T> callAsync(Callable<T> callable) {
        Preconditions.checkNotNull(callable, "callable");
        return CompletableFuture.supplyAsync(Scheduler.wrapCallable(callable), Scheduler.async());
    }

    public static CompletableFuture<Void> runSync(Runnable runnable) {
        Preconditions.checkNotNull(runnable, "runnable");
        return CompletableFuture.runAsync(Scheduler.wrapRunnable(runnable), Scheduler.sync());
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        Preconditions.checkNotNull(runnable, "runnable");
        return CompletableFuture.runAsync(Scheduler.wrapRunnable(runnable), Scheduler.async());
    }

    public static <T> CompletableFuture<T> supplyLaterSync(Supplier<T> supplier, long delay) {
        Preconditions.checkNotNull(supplier, "supplier");
        LumineFuture fut = new LumineFuture(null);
        BukkitTask task = Scheduler.bukkit().runTaskLater((Plugin)LoaderUtils.getPlugin(), () -> {
            fut.setExecuting();
            try (MCTiming t = Timings.get().ofStart("scheduler: " + supplier.getClass().getName());){
                Object result = supplier.get();
                fut.complete(result);
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                fut.completeExceptionally(t2);
            }
        }, delay);
        fut.setCancelCallback(() -> ((BukkitTask)task).cancel());
        return fut;
    }

    public static <T> CompletableFuture<T> supplyLaterAsync(Supplier<T> supplier, long delay) {
        Preconditions.checkNotNull(supplier, "supplier");
        LumineFuture fut = new LumineFuture(null);
        BukkitTask task = Scheduler.bukkit().runTaskLaterAsynchronously((Plugin)LoaderUtils.getPlugin(), () -> {
            fut.setExecuting();
            try {
                Object result = supplier.get();
                fut.complete(result);
            }
            catch (Throwable t) {
                EXCEPTION_CONSUMER.accept(t);
                fut.completeExceptionally(t);
            }
        }, delay);
        fut.setCancelCallback(() -> ((BukkitTask)task).cancel());
        return fut;
    }

    public static <T> CompletableFuture<T> callLaterSync(Callable<T> callable, long delay) {
        Preconditions.checkNotNull(callable, "callable");
        LumineFuture fut = new LumineFuture(null);
        BukkitTask task = Scheduler.bukkit().runTaskLater((Plugin)LoaderUtils.getPlugin(), () -> {
            fut.setExecuting();
            try (MCTiming t = Timings.get().ofStart("scheduler: " + callable.getClass().getName());){
                Object result = callable.call();
                fut.complete(result);
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                fut.completeExceptionally(t2);
            }
        }, delay);
        fut.setCancelCallback(() -> ((BukkitTask)task).cancel());
        return fut;
    }

    public static <T> CompletableFuture<T> callLaterAsync(Callable<T> callable, long delay) {
        Preconditions.checkNotNull(callable, "callable");
        LumineFuture fut = new LumineFuture(null);
        BukkitTask task = Scheduler.bukkit().runTaskLaterAsynchronously((Plugin)LoaderUtils.getPlugin(), () -> {
            fut.setExecuting();
            try {
                Object result = callable.call();
                fut.complete(result);
            }
            catch (Throwable t) {
                EXCEPTION_CONSUMER.accept(t);
                fut.completeExceptionally(t);
            }
        }, delay);
        fut.setCancelCallback(() -> ((BukkitTask)task).cancel());
        return fut;
    }

    public static CompletableFuture<Void> runLaterSync(Runnable runnable, long delay) {
        Preconditions.checkNotNull(runnable, "runnable");
        LumineFuture<Void> fut = new LumineFuture<Void>(null);
        BukkitTask task = Scheduler.bukkit().runTaskLater((Plugin)LoaderUtils.getPlugin(), () -> {
            ((LumineFuture)fut).setExecuting();
            try (MCTiming t = Timings.get().ofStart("scheduler: " + runnable.getClass().getName());){
                runnable.run();
                fut.complete(null);
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                fut.completeExceptionally(t2);
            }
        }, delay);
        ((LumineFuture)fut).setCancelCallback(() -> ((BukkitTask)task).cancel());
        return fut;
    }

    public static CompletableFuture<Void> runLaterAsync(Runnable runnable, long delay) {
        Preconditions.checkNotNull(runnable, "runnable");
        LumineFuture<Void> fut = new LumineFuture<Void>(null);
        BukkitTask task = Scheduler.bukkit().runTaskLaterAsynchronously((Plugin)LoaderUtils.getPlugin(), () -> {
            ((LumineFuture)fut).setExecuting();
            try {
                runnable.run();
                fut.complete(null);
            }
            catch (Throwable t) {
                EXCEPTION_CONSUMER.accept(t);
                fut.completeExceptionally(t);
            }
        }, delay);
        ((LumineFuture)fut).setCancelCallback(() -> ((BukkitTask)task).cancel());
        return fut;
    }

    public static Task runTaskRepeatingSync(Consumer<Task> consumer, long delay, long interval) {
        Preconditions.checkNotNull(consumer, "consumer");
        TaskImpl task = new TaskImpl(consumer);
        task.runTaskTimer((Plugin)LoaderUtils.getPlugin(), delay, interval);
        return task;
    }

    public static Task runTaskRepeatingAsync(Consumer<Task> consumer, long delay, long interval) {
        Preconditions.checkNotNull(consumer, "consumer");
        TaskImpl task = new TaskImpl(consumer);
        task.runTaskTimerAsynchronously((Plugin)LoaderUtils.getPlugin(), delay, interval);
        return task;
    }

    public static Task runTaskRepeatingSync(Runnable runnable, long delay, long interval) {
        Preconditions.checkNotNull(runnable, "runnable");
        return Scheduler.runTaskRepeatingSync(new DelegateConsumer<Task>(runnable), delay, interval);
    }

    public static Task runTaskRepeatingAsync(Runnable runnable, long delay, long interval) {
        Preconditions.checkNotNull(runnable, "runnable");
        return Scheduler.runTaskRepeatingAsync(new DelegateConsumer<Task>(runnable), delay, interval);
    }

    private static String getHandlerName(Consumer consumer) {
        if (consumer instanceof DelegateConsumer) {
            return ((DelegateConsumer)consumer).getDelegate().getClass().getName();
        }
        return consumer.getClass().getName();
    }

    private Scheduler() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static final class DelegateConsumer<T>
    implements Consumer<T> {
        private final Runnable delegate;

        private DelegateConsumer(Runnable delegate) {
            this.delegate = delegate;
        }

        public Runnable getDelegate() {
            return this.delegate;
        }

        @Override
        public void accept(T t) {
            this.delegate.run();
        }
    }

    private static class LumineFuture<T>
    extends CompletableFuture<T>
    implements Terminable {
        private Runnable cancelCallback = null;
        private boolean cancellable = true;
        private boolean cancelled = false;

        LumineFuture(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }

        private void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }

        private void setExecuting() {
            this.cancellable = false;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            if (this.cancelled) {
                return true;
            }
            if (!this.cancellable) {
                return false;
            }
            this.cancelled = true;
            if (this.cancelCallback != null) {
                this.cancelCallback.run();
            }
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public void close() {
            this.cancel(true);
        }

        @Override
        public boolean hasTerminated() {
            return this.cancelled;
        }
    }

    private static class TaskImpl
    extends BukkitRunnable
    implements Task {
        private final Consumer<Task> backingTask;
        private final MCTiming timing;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final AtomicBoolean shouldStop = new AtomicBoolean(false);

        private TaskImpl(Consumer<Task> backingTask) {
            this.backingTask = backingTask;
            this.timing = Timings.get().of("scheduler: " + Scheduler.getHandlerName(backingTask));
        }

        public void run() {
            if (this.shouldStop.get()) {
                this.cancel();
                return;
            }
            try {
                try (MCTiming t = this.timing.startTiming();){
                    this.backingTask.accept(this);
                }
                this.counter.incrementAndGet();
            }
            catch (Throwable t) {
                EXCEPTION_CONSUMER.accept(t);
            }
            if (this.shouldStop.get()) {
                this.cancel();
            }
        }

        @Override
        public int getTimesRan() {
            return this.counter.get();
        }

        @Override
        public boolean stop() {
            return !this.shouldStop.getAndSet(true);
        }

        @Override
        public int getBukkitId() {
            return this.getTaskId();
        }

        @Override
        public void close() {
            this.stop();
        }

        @Override
        public boolean hasTerminated() {
            return this.shouldStop.get();
        }
    }

    public static interface Task
    extends Terminable {
        public int getTimesRan();

        public boolean stop();

        public int getBukkitId();
    }
}

