/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.terminable.composite;

import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableConsumer;
import io.lumine.xikage.mythicmobs.utils.terminable.composite.AbstractCompositeTerminable;
import io.lumine.xikage.mythicmobs.utils.terminable.composite.AbstractWeakCompositeTerminable;
import io.lumine.xikage.mythicmobs.utils.terminable.composite.CompositeClosingException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface CompositeTerminable
extends Terminable,
TerminableConsumer {
    @Nonnull
    public static CompositeTerminable create() {
        return new AbstractCompositeTerminable();
    }

    @Nonnull
    public static CompositeTerminable createWeak() {
        return new AbstractWeakCompositeTerminable();
    }

    @Override
    public void close() throws CompositeClosingException;

    @Override
    @Nullable
    default public CompositeClosingException closeSilently() {
        try {
            this.close();
            return null;
        }
        catch (CompositeClosingException e) {
            return e;
        }
    }

    @Override
    default public void closeAndReportException() {
        try {
            this.close();
        }
        catch (CompositeClosingException e) {
            e.printAllStackTraces();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompositeTerminable with(AutoCloseable var1);

    default public CompositeTerminable withAll(AutoCloseable ... autoCloseables) {
        for (AutoCloseable autoCloseable : autoCloseables) {
            if (autoCloseable == null) continue;
            this.bind(autoCloseable);
        }
        return this;
    }

    default public CompositeTerminable withAll(Iterable<? extends AutoCloseable> autoCloseables) {
        for (AutoCloseable autoCloseable : autoCloseables) {
            if (autoCloseable == null) continue;
            this.bind(autoCloseable);
        }
        return this;
    }

    @Override
    @Nonnull
    default public <T extends AutoCloseable> T bind(@Nonnull T terminable) {
        this.with(terminable);
        return terminable;
    }

    public void cleanup();
}

