/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_14_R1;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.reflection.Reflector;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileWorldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.v1_14_R1.Block;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.Chunk;
import net.minecraft.server.v1_14_R1.DifficultyDamageScaler;
import net.minecraft.server.v1_14_R1.EntityFallingBlock;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.MathHelper;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_14_R1.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class VolatileWorldHandler_v1_14_R1
implements VolatileWorldHandler {
    Reflector<World> worldAccessList = new Reflector<World>(World.class, "v");

    public VolatileWorldHandler_v1_14_R1(VolatileCodeHandler handler) {
    }

    @Override
    public void registerWorldAccess(org.bukkit.World world) {
    }

    @Override
    public void unregisterWorldAccess(org.bukkit.World world) {
    }

    @Override
    public void playSoundAtLocation(AbstractLocation location, String sound, float volume, float pitch, double radius) {
        Location l = BukkitAdapter.adapt(location);
        l.getWorld().playSound(l, sound, volume, pitch);
    }

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        return null != nmsWorld.getChunkIfLoaded(x, z);
    }

    @Override
    public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
        if (chunk == null) {
            return 0;
        }
        int amount = 0;
        for (List slice : chunk.getEntitySlices()) {
            amount += slice.size();
        }
        return amount;
    }

    @Override
    public void doBlockTossEffect(AbstractLocation target, Material material, AbstractVector velocity, int duration, boolean hideSourceBlock) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer nmsWorld = bukkitWorld.getHandle();
        IBlockData blockState = material == null ? nmsWorld.getType(blockPosition) : ((CraftBlockData)Bukkit.createBlockData((Material)material)).getState();
        EntityFallingBlock block = new EntityFallingBlock((World)nmsWorld, (double)target.getBlockX() + 0.5, (double)(target.getBlockY() + 1), (double)target.getBlockZ() + 0.5, blockState);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity((net.minecraft.server.v1_14_R1.Entity)block, block.getEntityType(), Block.getCombinedId((IBlockData)blockState), blockPosition);
        PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(block.getId(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (hideSourceBlock) {
                p.sendBlockChange(location, Material.AIR, (byte)0);
            }
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet);
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packetV);
            Schedulers.async().runLater(() -> {
                PacketPlayOutEntityDestroy packet2 = new PacketPlayOutEntityDestroy(new int[]{block.getId()});
                ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet2);
                if (hideSourceBlock) {
                    p.sendBlockChange(location, location.getBlock().getType(), (byte)0);
                }
            }, duration);
        }
    }

    @Override
    public float getDifficultyScale(AbstractLocation location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    @Override
    public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        ArrayList<AbstractEntity> entities = new ArrayList<AbstractEntity>();
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(location.getWorld());
        WorldServer nmsWorld = bukkitWorld.getHandle();
        int smallX = MathHelper.floor((double)((location.getX() - radius) / 16.0));
        int bigX = MathHelper.floor((double)((location.getX() + radius) / 16.0));
        int smallZ = MathHelper.floor((double)((location.getZ() - radius) / 16.0));
        int bigZ = MathHelper.floor((double)((location.getZ() + radius) / 16.0));
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
                if (null == chunk) continue;
                for (List slice : chunk.getEntitySlices()) {
                    for (net.minecraft.server.v1_14_R1.Entity e : slice) {
                        AbstractEntity entity = BukkitAdapter.adapt((Entity)e.getBukkitEntity());
                        if (predicate != null && !predicate.test(entity)) continue;
                        entities.add(entity);
                    }
                }
            }
        }
        return entities;
    }
}

