/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.notification;

import com.volmit.adapt.api.notification.Notification;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;

public class AdvancementNotification
implements Notification {
    private final Material icon;
    private final String title;
    private final String description;
    private final AdvancementDisplay.AdvancementFrame frameType;
    private final String group;

    @Override
    public long getTotalDuration() {
        return 100L;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void play(AdaptPlayer p) {
        AdvancementDisplay d = new AdvancementDisplay(this.icon, this.buildTitle(), this.description, this.frameType, AdvancementVisibility.ALWAYS);
        Advancement a = new Advancement(null, new NameKey("adapt-notifications", "n" + p.getId() + RNG.r.lmax()), d, new AdvancementFlag[0]);
        if (p.getPlayer() != null) {
            a.displayToast(p.getPlayer());
        }
    }

    public String buildTitle() {
        if (this.description.trim().isEmpty()) {
            return this.title;
        }
        return this.title + "\n" + this.description;
    }

    private static Material $default$icon() {
        return Material.DIAMOND;
    }

    private static String $default$title() {
        return " ";
    }

    private static String $default$description() {
        return " ";
    }

    private static AdvancementDisplay.AdvancementFrame $default$frameType() {
        return AdvancementDisplay.AdvancementFrame.TASK;
    }

    private static String $default$group() {
        return "default";
    }

    AdvancementNotification(Material icon, String title, String description, AdvancementDisplay.AdvancementFrame frameType, String group) {
        this.icon = icon;
        this.title = title;
        this.description = description;
        this.frameType = frameType;
        this.group = group;
    }

    public static AdvancementNotificationBuilder builder() {
        return new AdvancementNotificationBuilder();
    }

    public Material getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public AdvancementDisplay.AdvancementFrame getFrameType() {
        return this.frameType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancementNotification)) {
            return false;
        }
        AdvancementNotification other = (AdvancementNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Material this$icon = this.getIcon();
        Material other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        AdvancementDisplay.AdvancementFrame this$frameType = this.getFrameType();
        AdvancementDisplay.AdvancementFrame other$frameType = other.getFrameType();
        if (this$frameType == null ? other$frameType != null : !((Object)((Object)this$frameType)).equals((Object)other$frameType)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdvancementNotification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Material $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        AdvancementDisplay.AdvancementFrame $frameType = this.getFrameType();
        result = result * 59 + ($frameType == null ? 43 : ((Object)((Object)$frameType)).hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }

    public String toString() {
        return "AdvancementNotification(icon=" + this.getIcon() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", frameType=" + this.getFrameType() + ", group=" + this.getGroup() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class AdvancementNotificationBuilder {
        private boolean icon$set;
        private Material icon$value;
        private boolean title$set;
        private String title$value;
        private boolean description$set;
        private String description$value;
        private boolean frameType$set;
        private AdvancementDisplay.AdvancementFrame frameType$value;
        private boolean group$set;
        private String group$value;

        AdvancementNotificationBuilder() {
        }

        public AdvancementNotificationBuilder icon(Material icon) {
            this.icon$value = icon;
            this.icon$set = true;
            return this;
        }

        public AdvancementNotificationBuilder title(String title) {
            this.title$value = title;
            this.title$set = true;
            return this;
        }

        public AdvancementNotificationBuilder description(String description) {
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        public AdvancementNotificationBuilder frameType(AdvancementDisplay.AdvancementFrame frameType) {
            this.frameType$value = frameType;
            this.frameType$set = true;
            return this;
        }

        public AdvancementNotificationBuilder group(String group) {
            this.group$value = group;
            this.group$set = true;
            return this;
        }

        public AdvancementNotification build() {
            Material icon$value = this.icon$value;
            if (!this.icon$set) {
                icon$value = AdvancementNotification.$default$icon();
            }
            String title$value = this.title$value;
            if (!this.title$set) {
                title$value = AdvancementNotification.$default$title();
            }
            String description$value = this.description$value;
            if (!this.description$set) {
                description$value = AdvancementNotification.$default$description();
            }
            AdvancementDisplay.AdvancementFrame frameType$value = this.frameType$value;
            if (!this.frameType$set) {
                frameType$value = AdvancementNotification.$default$frameType();
            }
            String group$value = this.group$value;
            if (!this.group$set) {
                group$value = AdvancementNotification.$default$group();
            }
            return new AdvancementNotification(icon$value, title$value, description$value, frameType$value, group$value);
        }

        public String toString() {
            return "AdvancementNotification.AdvancementNotificationBuilder(icon$value=" + this.icon$value + ", title$value=" + this.title$value + ", description$value=" + this.description$value + ", frameType$value=" + this.frameType$value + ", group$value=" + this.group$value + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

