/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.notification;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.notification.ActionBarNotification;
import com.volmit.adapt.api.notification.Notification;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Notifier
extends TickedObject {
    private final List<Notification> queue = new ArrayList<Notification>();
    private final AdaptPlayer target;
    private final Map<String, Long> lastSkills = new HashMap<String, Long>();
    private final Map<String, Double> lastSkillValues = new HashMap<String, Double>();
    private int busyTicks = 0;
    private int delayTicks = 0;
    private long lastInstance;

    public Notifier(AdaptPlayer target) {
        super("notifications", target.getPlayer().getUniqueId() + "-notify", 97L);
        this.target = target;
        this.lastInstance = 0L;
    }

    public void notifyXP(String line, double value) {
        try {
            if (!this.lastSkills.containsKey(line)) {
                this.lastSkillValues.put(line, 0.0);
            }
            this.lastSkills.put(line, M.ms());
            this.lastSkillValues.put(line, this.lastSkillValues.get(line) + value);
            this.lastInstance = M.ms();
            StringBuilder sb = new StringBuilder();
            for (String i : XList.reverse(XMap.sortKNumber(this.lastSkills))) {
                Skill<?> sk = this.getServer().getSkillRegistry().getSkill(i);
                sb.append(i.equals(line) ? sk.getDisplayName() : sk.getShortName()).append((Object)C.RESET).append((Object)C.GRAY).append(" +").append((Object)C.WHITE).append(line.equals(i) ? C.UNDERLINE : "").append(Form.f(this.lastSkillValues.get(i).intValue())).append((Object)C.RESET).append((Object)C.GRAY).append("XP ");
            }
            while (this.lastSkills.size() > 5) {
                String s = XList.reverse(XMap.sortKNumber(this.lastSkills)).get(0);
                this.lastSkills.remove(s);
                this.lastSkillValues.remove(s);
            }
            this.target.getActionBarNotifier().queue(ActionBarNotification.builder().duration(0L).maxTTL(M.ms() + 100L).title(sb.toString()).group("xp").build());
        }
        catch (Throwable e) {
            Adapt.verbose("Failed to notify xp: " + e.getMessage());
        }
    }

    public void queue(Notification ... f) {
        XList.add(this.queue, f);
    }

    public boolean isBusy() {
        return this.busyTicks > 1 || XList.isNotEmpty(this.queue);
    }

    @Override
    public void onTick() {
        Notification n;
        this.cleanupSkills();
        if (this.busyTicks > 6) {
            this.busyTicks = 6;
        }
        if (this.busyTicks-- > 0) {
            return;
        }
        if (this.busyTicks < 0) {
            this.busyTicks = 0;
        }
        --this.delayTicks;
        if (this.delayTicks > 0) {
            return;
        }
        if (this.delayTicks < 0) {
            this.delayTicks = 0;
        }
        if (!this.isBusy()) {
            this.cleanupStackedNotifications();
        }
        if ((n = XList.pop(this.queue)) == null) {
            return;
        }
        this.delayTicks = (int)((double)this.delayTicks + ((double)n.getTotalDuration() / 50.0 + 1.0));
        Adapt.verbose("Playing Notification " + n + " --> " + System.identityHashCode(this));
        n.play(this.target);
    }

    private void cleanupStackedNotifications() {
    }

    private void cleanupSkills() {
        for (String i : XMap.k(this.lastSkills)) {
            if (this.lastSkills.get(i) == null) {
                return;
            }
            if (M.ms() - this.lastSkills.get(i) <= 10000L && (M.ms() - this.lastInstance <= 3100L || M.ms() - this.lastSkills.get(i) <= 3100L)) continue;
            this.lastSkills.remove(i);
            this.lastSkillValues.remove(i);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Notifier)) {
            return false;
        }
        Notifier other = (Notifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBusyTicks() != other.getBusyTicks()) {
            return false;
        }
        if (this.getDelayTicks() != other.getDelayTicks()) {
            return false;
        }
        if (this.getLastInstance() != other.getLastInstance()) {
            return false;
        }
        List<Notification> this$queue = this.getQueue();
        List<Notification> other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !((Object)this$queue).equals(other$queue)) {
            return false;
        }
        AdaptPlayer this$target = this.getTarget();
        AdaptPlayer other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        Map<String, Long> this$lastSkills = this.getLastSkills();
        Map<String, Long> other$lastSkills = other.getLastSkills();
        if (this$lastSkills == null ? other$lastSkills != null : !((Object)this$lastSkills).equals(other$lastSkills)) {
            return false;
        }
        Map<String, Double> this$lastSkillValues = this.getLastSkillValues();
        Map<String, Double> other$lastSkillValues = other.getLastSkillValues();
        return !(this$lastSkillValues == null ? other$lastSkillValues != null : !((Object)this$lastSkillValues).equals(other$lastSkillValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Notifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBusyTicks();
        result = result * 59 + this.getDelayTicks();
        long $lastInstance = this.getLastInstance();
        result = result * 59 + (int)($lastInstance >>> 32 ^ $lastInstance);
        List<Notification> $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : ((Object)$queue).hashCode());
        AdaptPlayer $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        Map<String, Long> $lastSkills = this.getLastSkills();
        result = result * 59 + ($lastSkills == null ? 43 : ((Object)$lastSkills).hashCode());
        Map<String, Double> $lastSkillValues = this.getLastSkillValues();
        result = result * 59 + ($lastSkillValues == null ? 43 : ((Object)$lastSkillValues).hashCode());
        return result;
    }

    public List<Notification> getQueue() {
        return this.queue;
    }

    public AdaptPlayer getTarget() {
        return this.target;
    }

    public Map<String, Long> getLastSkills() {
        return this.lastSkills;
    }

    public Map<String, Double> getLastSkillValues() {
        return this.lastSkillValues;
    }

    public int getBusyTicks() {
        return this.busyTicks;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    public long getLastInstance() {
        return this.lastInstance;
    }

    public void setBusyTicks(int busyTicks) {
        this.busyTicks = busyTicks;
    }

    public void setDelayTicks(int delayTicks) {
        this.delayTicks = delayTicks;
    }

    public void setLastInstance(long lastInstance) {
        this.lastInstance = lastInstance;
    }

    public String toString() {
        return "Notifier(queue=" + this.getQueue() + ", target=" + this.getTarget() + ", lastSkills=" + this.getLastSkills() + ", lastSkillValues=" + this.getLastSkillValues() + ", busyTicks=" + this.getBusyTicks() + ", delayTicks=" + this.getDelayTicks() + ", lastInstance=" + this.getLastInstance() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

