/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.notification;

import com.volmit.adapt.api.notification.Notification;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Sound;

public class SoundNotification
implements Notification {
    private final long isolation;
    private final long predelay;
    private final Sound sound;
    private final float volume;
    private final float pitch;
    private final String group;

    public SoundNotification withXP(double xp) {
        double sig = xp / 1000.0;
        float pitch = this.pitch;
        float volume = this.volume;
        pitch = (double)(pitch = (float)((double)pitch - sig / 6.6)) < 0.1 ? 0.1f : pitch;
        double vp = sig / 5.0;
        vp = Math.min(vp, 0.8);
        volume = (float)((double)volume + vp);
        pitch = (double)pitch < 0.1 ? 0.1f : pitch;
        return SoundNotification.builder().sound(this.sound).isolation(this.isolation).predelay(this.predelay).volume(volume).pitch(pitch).build();
    }

    @Override
    public long getTotalDuration() {
        return this.isolation;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void play(AdaptPlayer p) {
        J.s(() -> p.getPlayer().playSound(p.getPlayer().getLocation(), this.sound, this.volume, this.pitch));
    }

    private static long $default$isolation() {
        return 0L;
    }

    private static long $default$predelay() {
        return 0L;
    }

    private static Sound $default$sound() {
        return Sound.BLOCK_LEVER_CLICK;
    }

    private static float $default$volume() {
        return 1.0f;
    }

    private static float $default$pitch() {
        return 1.0f;
    }

    private static String $default$group() {
        return "default";
    }

    SoundNotification(long isolation, long predelay, Sound sound, float volume, float pitch, String group) {
        this.isolation = isolation;
        this.predelay = predelay;
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.group = group;
    }

    public static SoundNotificationBuilder builder() {
        return new SoundNotificationBuilder();
    }

    public long getIsolation() {
        return this.isolation;
    }

    public long getPredelay() {
        return this.predelay;
    }

    public Sound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoundNotification)) {
            return false;
        }
        SoundNotification other = (SoundNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIsolation() != other.getIsolation()) {
            return false;
        }
        if (this.getPredelay() != other.getPredelay()) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        Sound this$sound = this.getSound();
        Sound other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SoundNotification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $isolation = this.getIsolation();
        result = result * 59 + (int)($isolation >>> 32 ^ $isolation);
        long $predelay = this.getPredelay();
        result = result * 59 + (int)($predelay >>> 32 ^ $predelay);
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        Sound $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }

    public String toString() {
        return "SoundNotification(isolation=" + this.getIsolation() + ", predelay=" + this.getPredelay() + ", sound=" + this.getSound() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ", group=" + this.getGroup() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class SoundNotificationBuilder {
        private boolean isolation$set;
        private long isolation$value;
        private boolean predelay$set;
        private long predelay$value;
        private boolean sound$set;
        private Sound sound$value;
        private boolean volume$set;
        private float volume$value;
        private boolean pitch$set;
        private float pitch$value;
        private boolean group$set;
        private String group$value;

        SoundNotificationBuilder() {
        }

        public SoundNotificationBuilder isolation(long isolation) {
            this.isolation$value = isolation;
            this.isolation$set = true;
            return this;
        }

        public SoundNotificationBuilder predelay(long predelay) {
            this.predelay$value = predelay;
            this.predelay$set = true;
            return this;
        }

        public SoundNotificationBuilder sound(Sound sound) {
            this.sound$value = sound;
            this.sound$set = true;
            return this;
        }

        public SoundNotificationBuilder volume(float volume) {
            this.volume$value = volume;
            this.volume$set = true;
            return this;
        }

        public SoundNotificationBuilder pitch(float pitch) {
            this.pitch$value = pitch;
            this.pitch$set = true;
            return this;
        }

        public SoundNotificationBuilder group(String group) {
            this.group$value = group;
            this.group$set = true;
            return this;
        }

        public SoundNotification build() {
            long isolation$value = this.isolation$value;
            if (!this.isolation$set) {
                isolation$value = SoundNotification.$default$isolation();
            }
            long predelay$value = this.predelay$value;
            if (!this.predelay$set) {
                predelay$value = SoundNotification.$default$predelay();
            }
            Sound sound$value = this.sound$value;
            if (!this.sound$set) {
                sound$value = SoundNotification.$default$sound();
            }
            float volume$value = this.volume$value;
            if (!this.volume$set) {
                volume$value = SoundNotification.$default$volume();
            }
            float pitch$value = this.pitch$value;
            if (!this.pitch$set) {
                pitch$value = SoundNotification.$default$pitch();
            }
            String group$value = this.group$value;
            if (!this.group$set) {
                group$value = SoundNotification.$default$group();
            }
            return new SoundNotification(isolation$value, predelay$value, sound$value, volume$value, pitch$value, group$value);
        }

        public String toString() {
            return "SoundNotification.SoundNotificationBuilder(isolation$value=" + this.isolation$value + ", predelay$value=" + this.predelay$value + ", sound$value=" + this.sound$value + ", volume$value=" + this.volume$value + ", pitch$value=" + this.pitch$value + ", group$value=" + this.group$value + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

