/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.notification;

import com.volmit.adapt.api.notification.Notification;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

public class TitleNotification
implements Notification {
    private final long in;
    private final long stay;
    private final long out;
    private final String title;
    private final String subtitle;
    private final String group;

    @Override
    public long getTotalDuration() {
        return this.in + this.out + this.stay;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void play(AdaptPlayer p) {
        p.getPlayer().sendTitle(this.title.isEmpty() ? " " : this.title, this.subtitle, (int)((double)this.in / 50.0), (int)((double)this.stay / 50.0), (int)((double)this.out / 50.0));
    }

    private static long $default$in() {
        return 250L;
    }

    private static long $default$stay() {
        return 1450L;
    }

    private static long $default$out() {
        return 750L;
    }

    private static String $default$title() {
        return " ";
    }

    private static String $default$subtitle() {
        return " ";
    }

    private static String $default$group() {
        return "default";
    }

    TitleNotification(long in, long stay, long out, String title, String subtitle, String group) {
        this.in = in;
        this.stay = stay;
        this.out = out;
        this.title = title;
        this.subtitle = subtitle;
        this.group = group;
    }

    public static TitleNotificationBuilder builder() {
        return new TitleNotificationBuilder();
    }

    public long getIn() {
        return this.in;
    }

    public long getStay() {
        return this.stay;
    }

    public long getOut() {
        return this.out;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TitleNotification)) {
            return false;
        }
        TitleNotification other = (TitleNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIn() != other.getIn()) {
            return false;
        }
        if (this.getStay() != other.getStay()) {
            return false;
        }
        if (this.getOut() != other.getOut()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subtitle = this.getSubtitle();
        String other$subtitle = other.getSubtitle();
        if (this$subtitle == null ? other$subtitle != null : !this$subtitle.equals(other$subtitle)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TitleNotification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $in = this.getIn();
        result = result * 59 + (int)($in >>> 32 ^ $in);
        long $stay = this.getStay();
        result = result * 59 + (int)($stay >>> 32 ^ $stay);
        long $out = this.getOut();
        result = result * 59 + (int)($out >>> 32 ^ $out);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subtitle = this.getSubtitle();
        result = result * 59 + ($subtitle == null ? 43 : $subtitle.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }

    public String toString() {
        return "TitleNotification(in=" + this.getIn() + ", stay=" + this.getStay() + ", out=" + this.getOut() + ", title=" + this.getTitle() + ", subtitle=" + this.getSubtitle() + ", group=" + this.getGroup() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class TitleNotificationBuilder {
        private boolean in$set;
        private long in$value;
        private boolean stay$set;
        private long stay$value;
        private boolean out$set;
        private long out$value;
        private boolean title$set;
        private String title$value;
        private boolean subtitle$set;
        private String subtitle$value;
        private boolean group$set;
        private String group$value;

        TitleNotificationBuilder() {
        }

        public TitleNotificationBuilder in(long in) {
            this.in$value = in;
            this.in$set = true;
            return this;
        }

        public TitleNotificationBuilder stay(long stay) {
            this.stay$value = stay;
            this.stay$set = true;
            return this;
        }

        public TitleNotificationBuilder out(long out) {
            this.out$value = out;
            this.out$set = true;
            return this;
        }

        public TitleNotificationBuilder title(String title) {
            this.title$value = title;
            this.title$set = true;
            return this;
        }

        public TitleNotificationBuilder subtitle(String subtitle) {
            this.subtitle$value = subtitle;
            this.subtitle$set = true;
            return this;
        }

        public TitleNotificationBuilder group(String group) {
            this.group$value = group;
            this.group$set = true;
            return this;
        }

        public TitleNotification build() {
            long in$value = this.in$value;
            if (!this.in$set) {
                in$value = TitleNotification.$default$in();
            }
            long stay$value = this.stay$value;
            if (!this.stay$set) {
                stay$value = TitleNotification.$default$stay();
            }
            long out$value = this.out$value;
            if (!this.out$set) {
                out$value = TitleNotification.$default$out();
            }
            String title$value = this.title$value;
            if (!this.title$set) {
                title$value = TitleNotification.$default$title();
            }
            String subtitle$value = this.subtitle$value;
            if (!this.subtitle$set) {
                subtitle$value = TitleNotification.$default$subtitle();
            }
            String group$value = this.group$value;
            if (!this.group$set) {
                group$value = TitleNotification.$default$group();
            }
            return new TitleNotification(in$value, stay$value, out$value, title$value, subtitle$value, group$value);
        }

        public String toString() {
            return "TitleNotification.TitleNotificationBuilder(in$value=" + this.in$value + ", stay$value=" + this.stay$value + ", out$value=" + this.out$value + ", title$value=" + this.title$value + ", subtitle$value=" + this.subtitle$value + ", group$value=" + this.group$value + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

