/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.potion;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class BrewingRecipe {
    private final String id;
    private final Material ingredient;
    private final ItemStack basePotion;
    private final ItemStack result;
    private final int brewingTime;
    private final int fuelCost;

    BrewingRecipe(String id, Material ingredient, ItemStack basePotion, ItemStack result, int brewingTime, int fuelCost) {
        this.id = id;
        this.ingredient = ingredient;
        this.basePotion = basePotion;
        this.result = result;
        this.brewingTime = brewingTime;
        this.fuelCost = fuelCost;
    }

    public static BrewingRecipeBuilder builder() {
        return new BrewingRecipeBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Material getIngredient() {
        return this.ingredient;
    }

    public ItemStack getBasePotion() {
        return this.basePotion;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getBrewingTime() {
        return this.brewingTime;
    }

    public int getFuelCost() {
        return this.fuelCost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrewingRecipe)) {
            return false;
        }
        BrewingRecipe other = (BrewingRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBrewingTime() != other.getBrewingTime()) {
            return false;
        }
        if (this.getFuelCost() != other.getFuelCost()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Material this$ingredient = this.getIngredient();
        Material other$ingredient = other.getIngredient();
        if (this$ingredient == null ? other$ingredient != null : !this$ingredient.equals(other$ingredient)) {
            return false;
        }
        ItemStack this$basePotion = this.getBasePotion();
        ItemStack other$basePotion = other.getBasePotion();
        if (this$basePotion == null ? other$basePotion != null : !this$basePotion.equals(other$basePotion)) {
            return false;
        }
        ItemStack this$result = this.getResult();
        ItemStack other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrewingRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBrewingTime();
        result = result * 59 + this.getFuelCost();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Material $ingredient = this.getIngredient();
        result = result * 59 + ($ingredient == null ? 43 : $ingredient.hashCode());
        ItemStack $basePotion = this.getBasePotion();
        result = result * 59 + ($basePotion == null ? 43 : $basePotion.hashCode());
        ItemStack $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "BrewingRecipe(id=" + this.getId() + ", ingredient=" + this.getIngredient() + ", basePotion=" + this.getBasePotion() + ", result=" + this.getResult() + ", brewingTime=" + this.getBrewingTime() + ", fuelCost=" + this.getFuelCost() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class BrewingRecipeBuilder {
        private String id;
        private Material ingredient;
        private ItemStack basePotion;
        private ItemStack result;
        private int brewingTime;
        private int fuelCost;

        BrewingRecipeBuilder() {
        }

        public BrewingRecipeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BrewingRecipeBuilder ingredient(Material ingredient) {
            this.ingredient = ingredient;
            return this;
        }

        public BrewingRecipeBuilder basePotion(ItemStack basePotion) {
            this.basePotion = basePotion;
            return this;
        }

        public BrewingRecipeBuilder result(ItemStack result) {
            this.result = result;
            return this;
        }

        public BrewingRecipeBuilder brewingTime(int brewingTime) {
            this.brewingTime = brewingTime;
            return this;
        }

        public BrewingRecipeBuilder fuelCost(int fuelCost) {
            this.fuelCost = fuelCost;
            return this;
        }

        public BrewingRecipe build() {
            return new BrewingRecipe(this.id, this.ingredient, this.basePotion, this.result, this.brewingTime, this.fuelCost);
        }

        public String toString() {
            return "BrewingRecipe.BrewingRecipeBuilder(id=" + this.id + ", ingredient=" + this.ingredient + ", basePotion=" + this.basePotion + ", result=" + this.result + ", brewingTime=" + this.brewingTime + ", fuelCost=" + this.fuelCost + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

