/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.protection;

import com.google.common.collect.ImmutableList;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;

public class ProtectorRegistry {
    private final List<Protector> protectors = new ArrayList<Protector>();

    public void registerProtector(Protector protector) {
        Adapt.verbose("Protector: \"" + protector.getName() + "\" registered.");
        this.protectors.add(protector);
    }

    public void unregisterProtector(Protector protector) {
        protector.unregister();
        this.protectors.remove(protector);
    }

    public List<Protector> getDefaultProtectors() {
        return (List)this.protectors.stream().filter(Protector::isEnabledByDefault).collect(ImmutableList.toImmutableList());
    }

    public List<Protector> getAllProtectors() {
        return ImmutableList.copyOf(this.protectors);
    }

    public void unregisterAll() {
        this.protectors.forEach(Protector::unregister);
        this.protectors.clear();
    }

    static {
        IBootstrap.dasBoot();
    }
}

