/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.recipe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.recipe.MaterialChar;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.plugin.Plugin;

public interface AdaptRecipe {
    public static Shapeless.ShapelessBuilder shapeless() {
        return Shapeless.builder();
    }

    public static Shaped.ShapedBuilder shaped() {
        return Shaped.builder();
    }

    public static Smithing.SmithingBuilder smithing() {
        return Smithing.builder();
    }

    public static Stonecutter.StonecutterBuilder stonecutter() {
        return Stonecutter.builder();
    }

    public static Smoker.SmokerBuilder smoker() {
        return Smoker.builder();
    }

    public static Blast.BlastBuilder blast() {
        return Blast.builder();
    }

    public static Furnace.FurnaceBuilder furnace() {
        return Furnace.builder();
    }

    public static Campfire.CampfireBuilder campfire() {
        return Campfire.builder();
    }

    public ItemStack getResult();

    public String getKey();

    default public NamespacedKey getNSKey() {
        return new NamespacedKey((Plugin)Adapt.instance, this.getKey());
    }

    public void register();

    public boolean is(Recipe var1);

    public void unregister();

    public static class Shapeless
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private List<Material> ingredients;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            ShapelessRecipe s = new ShapelessRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result);
            this.ingredients.forEach(arg_0 -> ((ShapelessRecipe)s).addIngredient(arg_0));
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Shapeless Crafting Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            ShapelessRecipe s;
            return recipe instanceof ShapelessRecipe && (s = (ShapelessRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Shapeless Crafting Recipe " + this.getKey());
        }

        Shapeless(String key, ItemStack result, List<Material> ingredients) {
            this.key = key;
            this.result = result;
            this.ingredients = ingredients;
        }

        public static ShapelessBuilder builder() {
            return new ShapelessBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public List<Material> getIngredients() {
            return this.ingredients;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setIngredients(List<Material> ingredients) {
            this.ingredients = ingredients;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Shapeless)) {
                return false;
            }
            Shapeless other = (Shapeless)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            List<Material> this$ingredients = this.getIngredients();
            List<Material> other$ingredients = other.getIngredients();
            return !(this$ingredients == null ? other$ingredients != null : !((Object)this$ingredients).equals(other$ingredients));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Shapeless;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            List<Material> $ingredients = this.getIngredients();
            result = result * 59 + ($ingredients == null ? 43 : ((Object)$ingredients).hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Shapeless(key=" + this.getKey() + ", result=" + this.getResult() + ", ingredients=" + this.getIngredients() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class ShapelessBuilder {
            private String key;
            private ItemStack result;
            private ArrayList<Material> ingredients;

            ShapelessBuilder() {
            }

            public ShapelessBuilder key(String key) {
                this.key = key;
                return this;
            }

            public ShapelessBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public ShapelessBuilder ingredient(Material ingredient) {
                if (this.ingredients == null) {
                    this.ingredients = new ArrayList();
                }
                this.ingredients.add(ingredient);
                return this;
            }

            public ShapelessBuilder ingredients(Collection<? extends Material> ingredients) {
                if (ingredients == null) {
                    throw new NullPointerException("ingredients cannot be null");
                }
                if (this.ingredients == null) {
                    this.ingredients = new ArrayList();
                }
                this.ingredients.addAll(ingredients);
                return this;
            }

            public ShapelessBuilder clearIngredients() {
                if (this.ingredients != null) {
                    this.ingredients.clear();
                }
                return this;
            }

            public Shapeless build() {
                return new Shapeless(this.key, this.result, switch (this.ingredients == null ? 0 : this.ingredients.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.ingredients.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<Material>(this.ingredients));
                });
            }

            public String toString() {
                return "AdaptRecipe.Shapeless.ShapelessBuilder(key=" + this.key + ", result=" + this.result + ", ingredients=" + this.ingredients + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    public static class Shaped
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private List<MaterialChar> ingredients;
        private List<String> shapes;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            ShapedRecipe s = new ShapedRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result);
            s.shape(this.shapes.toArray(new String[0]));
            this.ingredients.forEach(i -> s.setIngredient(i.getCharacter(), i.getMaterial()));
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Shaped Crafting Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            ShapedRecipe s;
            return recipe instanceof ShapedRecipe && (s = (ShapedRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Shaped Crafting Recipe " + this.getKey());
        }

        Shaped(String key, ItemStack result, List<MaterialChar> ingredients, List<String> shapes) {
            this.key = key;
            this.result = result;
            this.ingredients = ingredients;
            this.shapes = shapes;
        }

        public static ShapedBuilder builder() {
            return new ShapedBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public List<MaterialChar> getIngredients() {
            return this.ingredients;
        }

        public List<String> getShapes() {
            return this.shapes;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setIngredients(List<MaterialChar> ingredients) {
            this.ingredients = ingredients;
        }

        public void setShapes(List<String> shapes) {
            this.shapes = shapes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Shaped)) {
                return false;
            }
            Shaped other = (Shaped)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            List<MaterialChar> this$ingredients = this.getIngredients();
            List<MaterialChar> other$ingredients = other.getIngredients();
            if (this$ingredients == null ? other$ingredients != null : !((Object)this$ingredients).equals(other$ingredients)) {
                return false;
            }
            List<String> this$shapes = this.getShapes();
            List<String> other$shapes = other.getShapes();
            return !(this$shapes == null ? other$shapes != null : !((Object)this$shapes).equals(other$shapes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Shaped;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            List<MaterialChar> $ingredients = this.getIngredients();
            result = result * 59 + ($ingredients == null ? 43 : ((Object)$ingredients).hashCode());
            List<String> $shapes = this.getShapes();
            result = result * 59 + ($shapes == null ? 43 : ((Object)$shapes).hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Shaped(key=" + this.getKey() + ", result=" + this.getResult() + ", ingredients=" + this.getIngredients() + ", shapes=" + this.getShapes() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class ShapedBuilder {
            private String key;
            private ItemStack result;
            private ArrayList<MaterialChar> ingredients;
            private ArrayList<String> shapes;

            ShapedBuilder() {
            }

            public ShapedBuilder key(String key) {
                this.key = key;
                return this;
            }

            public ShapedBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public ShapedBuilder ingredient(MaterialChar ingredient) {
                if (this.ingredients == null) {
                    this.ingredients = new ArrayList();
                }
                this.ingredients.add(ingredient);
                return this;
            }

            public ShapedBuilder ingredients(Collection<? extends MaterialChar> ingredients) {
                if (ingredients == null) {
                    throw new NullPointerException("ingredients cannot be null");
                }
                if (this.ingredients == null) {
                    this.ingredients = new ArrayList();
                }
                this.ingredients.addAll(ingredients);
                return this;
            }

            public ShapedBuilder clearIngredients() {
                if (this.ingredients != null) {
                    this.ingredients.clear();
                }
                return this;
            }

            public ShapedBuilder shape(String shape) {
                if (this.shapes == null) {
                    this.shapes = new ArrayList();
                }
                this.shapes.add(shape);
                return this;
            }

            public ShapedBuilder shapes(Collection<? extends String> shapes) {
                if (shapes == null) {
                    throw new NullPointerException("shapes cannot be null");
                }
                if (this.shapes == null) {
                    this.shapes = new ArrayList();
                }
                this.shapes.addAll(shapes);
                return this;
            }

            public ShapedBuilder clearShapes() {
                if (this.shapes != null) {
                    this.shapes.clear();
                }
                return this;
            }

            public Shaped build() {
                return new Shaped(this.key, this.result, switch (this.ingredients == null ? 0 : this.ingredients.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.ingredients.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<MaterialChar>(this.ingredients));
                }, switch (this.shapes == null ? 0 : this.shapes.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.shapes.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<String>(this.shapes));
                });
            }

            public String toString() {
                return "AdaptRecipe.Shaped.ShapedBuilder(key=" + this.key + ", result=" + this.result + ", ingredients=" + this.ingredients + ", shapes=" + this.shapes + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    public static class Smithing
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private Material base;
        private Material addition;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            SmithingRecipe s = new SmithingRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result, (RecipeChoice)new RecipeChoice.ExactChoice(new ItemStack(this.base)), (RecipeChoice)new RecipeChoice.ExactChoice(new ItemStack(this.addition)));
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Smithing Table Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            SmithingRecipe s;
            return recipe instanceof SmithingRecipe && (s = (SmithingRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Smithing Table Recipe " + this.getKey());
        }

        Smithing(String key, ItemStack result, Material base, Material addition) {
            this.key = key;
            this.result = result;
            this.base = base;
            this.addition = addition;
        }

        public static SmithingBuilder builder() {
            return new SmithingBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public Material getBase() {
            return this.base;
        }

        public Material getAddition() {
            return this.addition;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setBase(Material base) {
            this.base = base;
        }

        public void setAddition(Material addition) {
            this.addition = addition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smithing)) {
                return false;
            }
            Smithing other = (Smithing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Material this$base = this.getBase();
            Material other$base = other.getBase();
            if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
                return false;
            }
            Material this$addition = this.getAddition();
            Material other$addition = other.getAddition();
            return !(this$addition == null ? other$addition != null : !this$addition.equals(other$addition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Smithing;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Material $base = this.getBase();
            result = result * 59 + ($base == null ? 43 : $base.hashCode());
            Material $addition = this.getAddition();
            result = result * 59 + ($addition == null ? 43 : $addition.hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Smithing(key=" + this.getKey() + ", result=" + this.getResult() + ", base=" + this.getBase() + ", addition=" + this.getAddition() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class SmithingBuilder {
            private String key;
            private ItemStack result;
            private Material base;
            private Material addition;

            SmithingBuilder() {
            }

            public SmithingBuilder key(String key) {
                this.key = key;
                return this;
            }

            public SmithingBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public SmithingBuilder base(Material base) {
                this.base = base;
                return this;
            }

            public SmithingBuilder addition(Material addition) {
                this.addition = addition;
                return this;
            }

            public Smithing build() {
                return new Smithing(this.key, this.result, this.base, this.addition);
            }

            public String toString() {
                return "AdaptRecipe.Smithing.SmithingBuilder(key=" + this.key + ", result=" + this.result + ", base=" + this.base + ", addition=" + this.addition + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    public static class Stonecutter
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private Material ingredient;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            StonecuttingRecipe s = new StonecuttingRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result, this.ingredient);
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Stone Cutter Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            StonecuttingRecipe s;
            return recipe instanceof StonecuttingRecipe && (s = (StonecuttingRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Stone Cutter Recipe " + this.getKey());
        }

        Stonecutter(String key, ItemStack result, Material ingredient) {
            this.key = key;
            this.result = result;
            this.ingredient = ingredient;
        }

        public static StonecutterBuilder builder() {
            return new StonecutterBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public Material getIngredient() {
            return this.ingredient;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setIngredient(Material ingredient) {
            this.ingredient = ingredient;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Stonecutter)) {
                return false;
            }
            Stonecutter other = (Stonecutter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Material this$ingredient = this.getIngredient();
            Material other$ingredient = other.getIngredient();
            return !(this$ingredient == null ? other$ingredient != null : !this$ingredient.equals(other$ingredient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Stonecutter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Material $ingredient = this.getIngredient();
            result = result * 59 + ($ingredient == null ? 43 : $ingredient.hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Stonecutter(key=" + this.getKey() + ", result=" + this.getResult() + ", ingredient=" + this.getIngredient() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class StonecutterBuilder {
            private String key;
            private ItemStack result;
            private Material ingredient;

            StonecutterBuilder() {
            }

            public StonecutterBuilder key(String key) {
                this.key = key;
                return this;
            }

            public StonecutterBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public StonecutterBuilder ingredient(Material ingredient) {
                this.ingredient = ingredient;
                return this;
            }

            public Stonecutter build() {
                return new Stonecutter(this.key, this.result, this.ingredient);
            }

            public String toString() {
                return "AdaptRecipe.Stonecutter.StonecutterBuilder(key=" + this.key + ", result=" + this.result + ", ingredient=" + this.ingredient + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    public static class Smoker
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private Material ingredient;
        private float experience;
        private int cookTime;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            SmokingRecipe s = new SmokingRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result, this.ingredient, this.experience, this.cookTime);
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Smoker Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            SmokingRecipe s;
            return recipe instanceof SmokingRecipe && (s = (SmokingRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Smoker Recipe " + this.getKey());
        }

        Smoker(String key, ItemStack result, Material ingredient, float experience, int cookTime) {
            this.key = key;
            this.result = result;
            this.ingredient = ingredient;
            this.experience = experience;
            this.cookTime = cookTime;
        }

        public static SmokerBuilder builder() {
            return new SmokerBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public Material getIngredient() {
            return this.ingredient;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getCookTime() {
            return this.cookTime;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setIngredient(Material ingredient) {
            this.ingredient = ingredient;
        }

        public void setExperience(float experience) {
            this.experience = experience;
        }

        public void setCookTime(int cookTime) {
            this.cookTime = cookTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smoker)) {
                return false;
            }
            Smoker other = (Smoker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
                return false;
            }
            if (this.getCookTime() != other.getCookTime()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Material this$ingredient = this.getIngredient();
            Material other$ingredient = other.getIngredient();
            return !(this$ingredient == null ? other$ingredient != null : !this$ingredient.equals(other$ingredient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Smoker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getExperience());
            result = result * 59 + this.getCookTime();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Material $ingredient = this.getIngredient();
            result = result * 59 + ($ingredient == null ? 43 : $ingredient.hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Smoker(key=" + this.getKey() + ", result=" + this.getResult() + ", ingredient=" + this.getIngredient() + ", experience=" + this.getExperience() + ", cookTime=" + this.getCookTime() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class SmokerBuilder {
            private String key;
            private ItemStack result;
            private Material ingredient;
            private float experience;
            private int cookTime;

            SmokerBuilder() {
            }

            public SmokerBuilder key(String key) {
                this.key = key;
                return this;
            }

            public SmokerBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public SmokerBuilder ingredient(Material ingredient) {
                this.ingredient = ingredient;
                return this;
            }

            public SmokerBuilder experience(float experience) {
                this.experience = experience;
                return this;
            }

            public SmokerBuilder cookTime(int cookTime) {
                this.cookTime = cookTime;
                return this;
            }

            public Smoker build() {
                return new Smoker(this.key, this.result, this.ingredient, this.experience, this.cookTime);
            }

            public String toString() {
                return "AdaptRecipe.Smoker.SmokerBuilder(key=" + this.key + ", result=" + this.result + ", ingredient=" + this.ingredient + ", experience=" + this.experience + ", cookTime=" + this.cookTime + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    public static class Blast
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private Material ingredient;
        private float experience;
        private int cookTime;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            BlastingRecipe s = new BlastingRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result, this.ingredient, this.experience, this.cookTime);
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Blast Furnace Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            BlastingRecipe s;
            return recipe instanceof BlastingRecipe && (s = (BlastingRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Blast Furnace Recipe " + this.getKey());
        }

        Blast(String key, ItemStack result, Material ingredient, float experience, int cookTime) {
            this.key = key;
            this.result = result;
            this.ingredient = ingredient;
            this.experience = experience;
            this.cookTime = cookTime;
        }

        public static BlastBuilder builder() {
            return new BlastBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public Material getIngredient() {
            return this.ingredient;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getCookTime() {
            return this.cookTime;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setIngredient(Material ingredient) {
            this.ingredient = ingredient;
        }

        public void setExperience(float experience) {
            this.experience = experience;
        }

        public void setCookTime(int cookTime) {
            this.cookTime = cookTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Blast)) {
                return false;
            }
            Blast other = (Blast)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
                return false;
            }
            if (this.getCookTime() != other.getCookTime()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Material this$ingredient = this.getIngredient();
            Material other$ingredient = other.getIngredient();
            return !(this$ingredient == null ? other$ingredient != null : !this$ingredient.equals(other$ingredient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Blast;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getExperience());
            result = result * 59 + this.getCookTime();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Material $ingredient = this.getIngredient();
            result = result * 59 + ($ingredient == null ? 43 : $ingredient.hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Blast(key=" + this.getKey() + ", result=" + this.getResult() + ", ingredient=" + this.getIngredient() + ", experience=" + this.getExperience() + ", cookTime=" + this.getCookTime() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class BlastBuilder {
            private String key;
            private ItemStack result;
            private Material ingredient;
            private float experience;
            private int cookTime;

            BlastBuilder() {
            }

            public BlastBuilder key(String key) {
                this.key = key;
                return this;
            }

            public BlastBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public BlastBuilder ingredient(Material ingredient) {
                this.ingredient = ingredient;
                return this;
            }

            public BlastBuilder experience(float experience) {
                this.experience = experience;
                return this;
            }

            public BlastBuilder cookTime(int cookTime) {
                this.cookTime = cookTime;
                return this;
            }

            public Blast build() {
                return new Blast(this.key, this.result, this.ingredient, this.experience, this.cookTime);
            }

            public String toString() {
                return "AdaptRecipe.Blast.BlastBuilder(key=" + this.key + ", result=" + this.result + ", ingredient=" + this.ingredient + ", experience=" + this.experience + ", cookTime=" + this.cookTime + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    public static class Furnace
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private Material ingredient;
        private float experience;
        private int cookTime;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            FurnaceRecipe s = new FurnaceRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result, this.ingredient, this.experience, this.cookTime);
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Furnace Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            FurnaceRecipe s;
            return recipe instanceof FurnaceRecipe && (s = (FurnaceRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Furnace Recipe " + this.getKey());
        }

        Furnace(String key, ItemStack result, Material ingredient, float experience, int cookTime) {
            this.key = key;
            this.result = result;
            this.ingredient = ingredient;
            this.experience = experience;
            this.cookTime = cookTime;
        }

        public static FurnaceBuilder builder() {
            return new FurnaceBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public Material getIngredient() {
            return this.ingredient;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getCookTime() {
            return this.cookTime;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setIngredient(Material ingredient) {
            this.ingredient = ingredient;
        }

        public void setExperience(float experience) {
            this.experience = experience;
        }

        public void setCookTime(int cookTime) {
            this.cookTime = cookTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Furnace)) {
                return false;
            }
            Furnace other = (Furnace)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
                return false;
            }
            if (this.getCookTime() != other.getCookTime()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Material this$ingredient = this.getIngredient();
            Material other$ingredient = other.getIngredient();
            return !(this$ingredient == null ? other$ingredient != null : !this$ingredient.equals(other$ingredient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Furnace;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getExperience());
            result = result * 59 + this.getCookTime();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Material $ingredient = this.getIngredient();
            result = result * 59 + ($ingredient == null ? 43 : $ingredient.hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Furnace(key=" + this.getKey() + ", result=" + this.getResult() + ", ingredient=" + this.getIngredient() + ", experience=" + this.getExperience() + ", cookTime=" + this.getCookTime() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class FurnaceBuilder {
            private String key;
            private ItemStack result;
            private Material ingredient;
            private float experience;
            private int cookTime;

            FurnaceBuilder() {
            }

            public FurnaceBuilder key(String key) {
                this.key = key;
                return this;
            }

            public FurnaceBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public FurnaceBuilder ingredient(Material ingredient) {
                this.ingredient = ingredient;
                return this;
            }

            public FurnaceBuilder experience(float experience) {
                this.experience = experience;
                return this;
            }

            public FurnaceBuilder cookTime(int cookTime) {
                this.cookTime = cookTime;
                return this;
            }

            public Furnace build() {
                return new Furnace(this.key, this.result, this.ingredient, this.experience, this.cookTime);
            }

            public String toString() {
                return "AdaptRecipe.Furnace.FurnaceBuilder(key=" + this.key + ", result=" + this.result + ", ingredient=" + this.ingredient + ", experience=" + this.experience + ", cookTime=" + this.cookTime + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    public static class Campfire
    implements AdaptRecipe {
        private String key;
        private ItemStack result;
        private Material ingredient;
        private float experience;
        private int cookTime;

        @Override
        public ItemStack getResult() {
            return null;
        }

        @Override
        public void register() {
            CampfireRecipe s = new CampfireRecipe(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), this.result, this.ingredient, this.experience, this.cookTime);
            Bukkit.getServer().addRecipe((Recipe)s);
            Adapt.verbose("Registered Campfire Recipe " + s.getKey());
        }

        @Override
        public boolean is(Recipe recipe) {
            CampfireRecipe s;
            return recipe instanceof CampfireRecipe && (s = (CampfireRecipe)recipe).getKey().equals((Object)this.getNSKey());
        }

        @Override
        public void unregister() {
            Bukkit.getServer().removeRecipe(this.getNSKey());
            Adapt.verbose("Unregistered Campfire Recipe " + this.getKey());
        }

        Campfire(String key, ItemStack result, Material ingredient, float experience, int cookTime) {
            this.key = key;
            this.result = result;
            this.ingredient = ingredient;
            this.experience = experience;
            this.cookTime = cookTime;
        }

        public static CampfireBuilder builder() {
            return new CampfireBuilder();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public Material getIngredient() {
            return this.ingredient;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getCookTime() {
            return this.cookTime;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public void setIngredient(Material ingredient) {
            this.ingredient = ingredient;
        }

        public void setExperience(float experience) {
            this.experience = experience;
        }

        public void setCookTime(int cookTime) {
            this.cookTime = cookTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Campfire)) {
                return false;
            }
            Campfire other = (Campfire)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
                return false;
            }
            if (this.getCookTime() != other.getCookTime()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            ItemStack this$result = this.getResult();
            ItemStack other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Material this$ingredient = this.getIngredient();
            Material other$ingredient = other.getIngredient();
            return !(this$ingredient == null ? other$ingredient != null : !this$ingredient.equals(other$ingredient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Campfire;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getExperience());
            result = result * 59 + this.getCookTime();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            ItemStack $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Material $ingredient = this.getIngredient();
            result = result * 59 + ($ingredient == null ? 43 : $ingredient.hashCode());
            return result;
        }

        public String toString() {
            return "AdaptRecipe.Campfire(key=" + this.getKey() + ", result=" + this.getResult() + ", ingredient=" + this.getIngredient() + ", experience=" + this.getExperience() + ", cookTime=" + this.getCookTime() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class CampfireBuilder {
            private String key;
            private ItemStack result;
            private Material ingredient;
            private float experience;
            private int cookTime;

            CampfireBuilder() {
            }

            public CampfireBuilder key(String key) {
                this.key = key;
                return this;
            }

            public CampfireBuilder result(ItemStack result) {
                this.result = result;
                return this;
            }

            public CampfireBuilder ingredient(Material ingredient) {
                this.ingredient = ingredient;
                return this;
            }

            public CampfireBuilder experience(float experience) {
                this.experience = experience;
                return this;
            }

            public CampfireBuilder cookTime(int cookTime) {
                this.cookTime = cookTime;
                return this;
            }

            public Campfire build() {
                return new Campfire(this.key, this.result, this.ingredient, this.experience, this.cookTime);
            }

            public String toString() {
                return "AdaptRecipe.Campfire.CampfireBuilder(key=" + this.key + ", result=" + this.result + ", ingredient=" + this.ingredient + ", experience=" + this.experience + ", cookTime=" + this.cookTime + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }
}

