/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.skill;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.Ticked;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.arcane.amulet.io.FileWatcher;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;

public abstract class SimpleSkill<T>
extends TickedObject
implements Skill<T> {
    private final String name;
    private final String emojiName;
    private C color;
    private double minXp;
    private String description;
    private String displayName;
    private Material icon;
    private List<Adaptation<?>> adaptations;
    private List<AdaptStatTracker> statTrackers = new ArrayList<AdaptStatTracker>();
    private List<AdaptAdvancement> cachedAdvancements;
    private String advancementBackground;
    private List<AdaptRecipe> recipes = new ArrayList<AdaptRecipe>();
    private Class<T> configType;
    private T config;

    public SimpleSkill(String name, String emojiName) {
        super("skill", UUID.randomUUID() + "-skill-" + name, 50L);
        this.cachedAdvancements = new ArrayList<AdaptAdvancement>();
        this.emojiName = emojiName;
        this.adaptations = new ArrayList();
        this.setColor(C.WHITE);
        this.name = name;
        this.setIcon(Material.BOOK);
        this.setDescription("No Description Provided");
        this.setMinXp(100.0);
        this.setAdvancementBackground("minecraft:textures/block/deepslate_tiles.png");
        J.a(() -> {
            J.attempt(this::getConfig);
            this.getAdaptations().forEach(i -> J.attempt(i::getConfig));
        }, 1);
    }

    @Override
    public Class<T> getConfigurationClass() {
        return this.configType;
    }

    @Override
    public void registerConfiguration(Class<T> type) {
        this.configType = type;
        final File file = Adapt.instance.getDataFile("adapt", "skills", this.getName() + ".json");
        final FileWatcher fw = new FileWatcher(file);
        fw.checkModified();
        J.a(() -> {
            fw.checkModified();
            Adapt.instance.getTicker().register(new TickedObject("config", "config-" + this.getName(), 1000L){

                @Override
                public void onTick() {
                    if (fw.checkModified() && file.exists()) {
                        SimpleSkill.this.config = null;
                        SimpleSkill.this.getConfig();
                        Adapt.info("Hotloaded " + file.getPath());
                        Adapt.hotloaded();
                        fw.checkModified();
                    }
                }
            });
        }, 20);
    }

    @Override
    public T getConfig() {
        block7: {
            try {
                if (this.config != null) break block7;
                T dummy = this.getConfigurationClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                File l = Adapt.instance.getDataFile("adapt", "skills", this.getName() + ".json");
                if (!l.exists()) {
                    try {
                        IO.writeAll(l, new JSONObject(new Gson().toJson(dummy)).toString(4));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.config = dummy;
                        return this.config;
                    }
                }
                try {
                    this.config = new Gson().fromJson(IO.readAll(l), this.getConfigurationClass());
                    IO.writeAll(l, new JSONObject(new Gson().toJson(this.config)).toString(4));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.config = dummy;
                    return this.config;
                }
            }
            catch (Throwable e) {
                Adapt.verbose("Failed to load config for " + this.getName());
            }
        }
        return this.config;
    }

    public void registerRecipe(AdaptRecipe r) {
        this.recipes.add(r);
    }

    public void registerAdvancement(AdaptAdvancement a) {
        this.cachedAdvancements.add(a);
    }

    public boolean checkValidEntity(EntityType e) {
        if (!e.isAlive()) {
            return false;
        }
        return !ItemListings.getInvalidDamageableEntities().contains(e);
    }

    protected boolean shouldReturnForPlayer(Player p) {
        if (p == null) {
            return true;
        }
        Adapt.verbose("Checking " + p.getName() + " for " + this.getName());
        return !this.isEnabled() || this.hasBlacklistPermission(p, this) || this.isWorldBlacklisted(p) || this.isInCreativeOrSpectator(p);
    }

    protected void shouldReturnForPlayer(Player p, Runnable r) {
        if (this.shouldReturnForPlayer(p)) {
            return;
        }
        r.run();
    }

    protected void shouldReturnForPlayer(Player p, Cancellable c, Runnable r) {
        if (c.isCancelled()) {
            return;
        }
        if (this.shouldReturnForPlayer(p)) {
            return;
        }
        r.run();
    }

    protected boolean shouldReturnForWorld(World world, Skill skill) {
        return !skill.isEnabled() || AdaptConfig.get().blacklistedWorlds.contains(world.getName());
    }

    protected boolean isWorldBlacklisted(Player p) {
        return AdaptConfig.get().blacklistedWorlds.contains(p.getWorld().getName());
    }

    protected boolean isInCreativeOrSpectator(Player p) {
        return !AdaptConfig.get().isXpInCreative() && (p.getGameMode().equals((Object)GameMode.CREATIVE) || p.getGameMode().equals((Object)GameMode.SPECTATOR));
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? Skill.super.getDisplayName() : C.RESET + C.BOLD + this.getColor().toString() + this.getEmojiName() + " " + this.displayName;
    }

    @Override
    public void onRegisterAdvancements(List<AdaptAdvancement> advancements) {
        advancements.addAll(this.cachedAdvancements);
    }

    @Override
    public AdaptAdvancement buildAdvancements() {
        ArrayList<AdaptAdvancement> a = new ArrayList<AdaptAdvancement>();
        this.onRegisterAdvancements(a);
        for (Adaptation<?> i : this.getAdaptations()) {
            a.add(i.buildAdvancements());
        }
        return AdaptAdvancement.builder().background(this.getAdvancementBackground()).key("skill_" + this.getName()).title(this.displayName).description(this.getDescription()).icon(this.getIcon()).children(a).visibility(AdvancementVisibility.HIDDEN).build();
    }

    @Override
    public void registerStatTracker(AdaptStatTracker tracker) {
        this.getStatTrackers().add(tracker);
    }

    @Override
    public List<AdaptStatTracker> getStatTrackers() {
        return this.statTrackers;
    }

    @Override
    public void registerAdaptation(Adaptation<?> a) {
        if (!a.isEnabled()) {
            return;
        }
        a.setSkill(this);
        this.adaptations.add(a);
    }

    @Override
    public void unregister() {
        this.adaptations.forEach(Ticked::unregister);
    }

    @Override
    public abstract void onTick();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleSkill)) {
            return false;
        }
        SimpleSkill other = (SimpleSkill)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMinXp(), other.getMinXp()) != 0) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$emojiName = this.getEmojiName();
        String other$emojiName = other.getEmojiName();
        if (this$emojiName == null ? other$emojiName != null : !this$emojiName.equals(other$emojiName)) {
            return false;
        }
        C this$color = this.getColor();
        C other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Material this$icon = this.getIcon();
        Material other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        List<AdaptStatTracker> this$statTrackers = this.getStatTrackers();
        List<AdaptStatTracker> other$statTrackers = other.getStatTrackers();
        if (this$statTrackers == null ? other$statTrackers != null : !((Object)this$statTrackers).equals(other$statTrackers)) {
            return false;
        }
        List<AdaptAdvancement> this$cachedAdvancements = this.getCachedAdvancements();
        List<AdaptAdvancement> other$cachedAdvancements = other.getCachedAdvancements();
        if (this$cachedAdvancements == null ? other$cachedAdvancements != null : !((Object)this$cachedAdvancements).equals(other$cachedAdvancements)) {
            return false;
        }
        String this$advancementBackground = this.getAdvancementBackground();
        String other$advancementBackground = other.getAdvancementBackground();
        if (this$advancementBackground == null ? other$advancementBackground != null : !this$advancementBackground.equals(other$advancementBackground)) {
            return false;
        }
        List<AdaptRecipe> this$recipes = this.getRecipes();
        List<AdaptRecipe> other$recipes = other.getRecipes();
        if (this$recipes == null ? other$recipes != null : !((Object)this$recipes).equals(other$recipes)) {
            return false;
        }
        Class<T> this$configType = this.getConfigType();
        Class<T> other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        T this$config = this.getConfig();
        T other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleSkill;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minXp = Double.doubleToLongBits(this.getMinXp());
        result = result * 59 + (int)($minXp >>> 32 ^ $minXp);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $emojiName = this.getEmojiName();
        result = result * 59 + ($emojiName == null ? 43 : $emojiName.hashCode());
        C $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Material $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        List<AdaptStatTracker> $statTrackers = this.getStatTrackers();
        result = result * 59 + ($statTrackers == null ? 43 : ((Object)$statTrackers).hashCode());
        List<AdaptAdvancement> $cachedAdvancements = this.getCachedAdvancements();
        result = result * 59 + ($cachedAdvancements == null ? 43 : ((Object)$cachedAdvancements).hashCode());
        String $advancementBackground = this.getAdvancementBackground();
        result = result * 59 + ($advancementBackground == null ? 43 : $advancementBackground.hashCode());
        List<AdaptRecipe> $recipes = this.getRecipes();
        result = result * 59 + ($recipes == null ? 43 : ((Object)$recipes).hashCode());
        Class<T> $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        T $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmojiName() {
        return this.emojiName;
    }

    @Override
    public C getColor() {
        return this.color;
    }

    @Override
    public double getMinXp() {
        return this.minXp;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Material getIcon() {
        return this.icon;
    }

    @Override
    public List<Adaptation<?>> getAdaptations() {
        return this.adaptations;
    }

    public List<AdaptAdvancement> getCachedAdvancements() {
        return this.cachedAdvancements;
    }

    public String getAdvancementBackground() {
        return this.advancementBackground;
    }

    @Override
    public List<AdaptRecipe> getRecipes() {
        return this.recipes;
    }

    public Class<T> getConfigType() {
        return this.configType;
    }

    public void setColor(C color) {
        this.color = color;
    }

    public void setMinXp(double minXp) {
        this.minXp = minXp;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public void setAdaptations(List<Adaptation<?>> adaptations) {
        this.adaptations = adaptations;
    }

    public void setStatTrackers(List<AdaptStatTracker> statTrackers) {
        this.statTrackers = statTrackers;
    }

    public void setCachedAdvancements(List<AdaptAdvancement> cachedAdvancements) {
        this.cachedAdvancements = cachedAdvancements;
    }

    public void setAdvancementBackground(String advancementBackground) {
        this.advancementBackground = advancementBackground;
    }

    public void setRecipes(List<AdaptRecipe> recipes) {
        this.recipes = recipes;
    }

    public void setConfigType(Class<T> configType) {
        this.configType = configType;
    }

    public void setConfig(T config) {
        this.config = config;
    }

    public String toString() {
        return "SimpleSkill(name=" + this.getName() + ", emojiName=" + this.getEmojiName() + ", color=" + this.getColor() + ", minXp=" + this.getMinXp() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", icon=" + this.getIcon() + ", adaptations=" + this.getAdaptations() + ", statTrackers=" + this.getStatTrackers() + ", cachedAdvancements=" + this.getCachedAdvancements() + ", advancementBackground=" + this.getAdvancementBackground() + ", recipes=" + this.getRecipes() + ", configType=" + this.getConfigType() + ", config=" + this.getConfig() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

