/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.notification.AdvancementNotification;
import com.volmit.adapt.api.notification.Notifier;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdvancementHandler;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.ChronoLatch;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RollingSequence;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class AdaptPlayer
extends TickedObject {
    private final Player player;
    private final PlayerData data;
    private ChronoLatch savelatch;
    private ChronoLatch updatelatch;
    private Notifier not;
    private Notifier actionBarNotifier;
    private AdvancementHandler advancementHandler;
    private RollingSequence speed;
    private long lastloc;
    private Vector velocity;
    private Location lastpos;

    public AdaptPlayer(Player p) {
        super("players", p.getUniqueId().toString(), 50L);
        this.player = p;
        this.data = this.loadPlayerData();
        this.updatelatch = new ChronoLatch(1000L);
        this.savelatch = new ChronoLatch(60000L);
        this.not = new Notifier(this);
        this.actionBarNotifier = new Notifier(this);
        this.advancementHandler = new AdvancementHandler(this);
        this.speed = new RollingSequence(7);
        this.lastloc = M.ms();
        this.getAdvancementHandler().activate();
        this.velocity = new Vector();
    }

    public boolean canConsumeFood(double cost, int minFood) {
        return (double)((float)this.player.getFoodLevel() + this.player.getSaturation() - (float)minFood) > cost;
    }

    public boolean consumeFood(double cost, int minFood) {
        if (this.canConsumeFood(cost, minFood)) {
            int food = this.player.getFoodLevel();
            double sat = this.player.getSaturation();
            if (sat >= cost) {
                sat = (double)this.player.getSaturation() - cost;
                cost = 0.0;
            } else if (this.player.getSaturation() > 0.0f) {
                cost -= sat;
                sat = 0.0;
            }
            if (cost >= 1.0) {
                food -= (int)Math.floor(cost);
                cost = Math.floor(cost);
            }
            if (cost > 0.0) {
                if (sat >= cost) {
                    sat -= cost;
                    cost = 0.0;
                } else {
                    sat += 1.0;
                    --food;
                }
            }
            if (sat >= cost && cost > 0.0) {
                sat -= cost;
                cost = 0.0;
            }
            this.player.setFoodLevel(food);
            this.player.setSaturation((float)sat);
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return this.not.isBusy();
    }

    public PlayerSkillLine getSkillLine(String l) {
        return this.getData().getSkillLine(l);
    }

    private void save() {
        UUID uuid = this.player.getUniqueId();
        String data = new Gson().toJson((Object)this.data);
        if (Adapt.instance.getSqlManager().useSql()) {
            Adapt.instance.getSqlManager().updateData(uuid, data);
        } else {
            IO.writeAll(this.getPlayerDataFile(uuid), new JSONObject(data).toString(4));
        }
    }

    private void unSave() {
        UUID uuid = this.player.getUniqueId();
        String data = new Gson().toJson((Object)new PlayerData());
        this.unregister();
        if (Adapt.instance.getSqlManager().useSql()) {
            Adapt.instance.getSqlManager().updateData(uuid, data);
        } else {
            IO.writeAll(this.getPlayerDataFile(uuid), new JSONObject(data).toString(4));
        }
    }

    @Override
    public void unregister() {
        super.unregister();
        this.getAdvancementHandler().deactivate();
        this.save();
    }

    public void delete(UUID uuid) {
        File local = this.getPlayerDataFile(this.player.getUniqueId());
        Adapt.warn("Deleting Player Data: " + local.getAbsolutePath());
        Player p = this.player;
        J.s(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            p.kickPlayer("Your data has been deleted.");
            if (local.exists()) {
                local.delete();
                this.unSave();
                local.delete();
                this.save();
                local.delete();
                this.unSave();
            }
            if (Adapt.instance.getSqlManager().useSql()) {
                Adapt.instance.getSqlManager().delete(uuid);
            }
        });
    }

    private PlayerData loadPlayerData() {
        File f;
        boolean upload = false;
        if (Adapt.instance.getSqlManager().useSql()) {
            String sqlData = Adapt.instance.getSqlManager().fetchData(this.player.getUniqueId());
            if (sqlData != null) {
                return (PlayerData)new Gson().fromJson(sqlData, PlayerData.class);
            }
            upload = true;
        }
        if ((f = this.getPlayerDataFile(this.player.getUniqueId())).exists()) {
            try {
                String text = IO.readAll(f);
                if (upload) {
                    Adapt.instance.getSqlManager().updateData(this.player.getUniqueId(), text);
                }
                return (PlayerData)new Gson().fromJson(text, PlayerData.class);
            }
            catch (Throwable ignored) {
                Adapt.verbose("Failed to load player data for " + this.player.getName() + " (" + this.player.getUniqueId() + ")");
            }
        }
        return new PlayerData();
    }

    @Override
    public void onTick() {
        if (this.updatelatch.flip()) {
            this.getData().update(this);
        }
        if (this.savelatch.flip()) {
            this.save();
        }
        this.getServer().takeSpatial(this);
        Location at = this.player.getLocation();
        if (this.lastpos != null && this.lastpos.getWorld().equals(at.getWorld()) && this.lastpos.distanceSquared(at) <= 49.0) {
            this.speed.put(this.lastpos.distance(at) / ((double)(M.ms() - this.lastloc) / 50.0));
            this.velocity = this.velocity.clone().add(at.clone().subtract(this.lastpos).toVector()).multiply(0.5);
            this.velocity.setX(Math.abs(this.velocity.getX()) < 0.01 ? 0.0 : this.velocity.getX());
            this.velocity.setY(Math.abs(this.velocity.getY()) < 0.01 ? 0.0 : this.velocity.getY());
            this.velocity.setZ(Math.abs(this.velocity.getZ()) < 0.01 ? 0.0 : this.velocity.getZ());
        }
        this.lastpos = at.clone();
        this.lastloc = M.ms();
    }

    public double getSpeed() {
        return this.speed.getAverage();
    }

    public boolean hasAdaptation(String id) {
        String skillLine = id.split("-")[0];
        Adapt.verbose("Checking for adaptation " + id + " in skill line " + skillLine);
        if (skillLine == null) {
            return false;
        }
        PlayerSkillLine line = this.getData().getSkillLine(skillLine);
        Adapt.verbose("Found skill line " + line);
        if (line.getAdaptation(id) == null || line.getAdaptation(id).getLevel() == 0) {
            Adapt.verbose("Adaptation " + id + " not found or level 0");
            return false;
        }
        return line.getAdaptation(id).getLevel() > 0;
    }

    public void giveXPToRecents(AdaptPlayer p, double xpGained, int ms) {
        for (PlayerSkillLine i : XMap.v(p.getData().getSkillLines())) {
            if (M.ms() - i.getLast() >= (long)ms) continue;
            i.giveXP(this.not, xpGained);
        }
    }

    public void giveXPToRandom(AdaptPlayer p, double xpGained) {
        XList.getRandom(XMap.v(p.getData().getSkillLines())).giveXP(p.getNot(), xpGained);
    }

    public void boostXPToRandom(AdaptPlayer p, double boost, int ms) {
        XList.getRandom(XMap.v(p.getData().getSkillLines())).boost(boost, ms);
    }

    public void boostXPToRecents(double boost, int ms) {
        for (PlayerSkillLine i : XMap.v(this.getData().getSkillLines())) {
            if (M.ms() - i.getLast() >= (long)ms) continue;
            i.boost(boost, ms);
        }
    }

    public void loggedIn() {
        if (AdaptConfig.get().isLoginBonus()) {
            long timeGone = M.ms() - this.getData().getLastLogin();
            boolean first = this.getData().getLastLogin() == 0L;
            this.getData().setLastLogin(M.ms());
            long boostTime = (long)Math.min((double)timeGone / 12.0, (double)TimeUnit.HOURS.toMillis(1L));
            if (boostTime < TimeUnit.MINUTES.toMillis(5L)) {
                return;
            }
            double boostAmount = M.lerp(0.1, 0.25, (double)boostTime / (double)TimeUnit.HOURS.toMillis(1L));
            this.getData().globalXPMultiplier(boostAmount, (int)boostTime);
            this.getNot().queue(AdvancementNotification.builder().title(first ? Localizer.dLocalize("snippets", "gui", "welcome") : Localizer.dLocalize("snippets", "gui", "welcomeback")).description("+" + C.GREEN + Form.pc(boostAmount, 0) + C.GRAY + " " + Localizer.dLocalize("snippets", "gui", "xpbonusfortime") + " " + C.AQUA + Form.duration(boostTime, 0)).build());
        }
    }

    public boolean hasSkill(Skill s) {
        return this.getData().getSkillLines().containsKey(s.getName()) && this.getData().getSkillLines().get(s.getId()).getXp() > 1.0;
    }

    private File getPlayerDataFile(UUID uuid) {
        return new File(Adapt.instance.getDataFolder("data", "players"), uuid.toString() + ".json");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaptPlayer)) {
            return false;
        }
        AdaptPlayer other = (AdaptPlayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastloc() != other.getLastloc()) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        PlayerData this$data = this.getData();
        PlayerData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        ChronoLatch this$savelatch = this.getSavelatch();
        ChronoLatch other$savelatch = other.getSavelatch();
        if (this$savelatch == null ? other$savelatch != null : !this$savelatch.equals(other$savelatch)) {
            return false;
        }
        ChronoLatch this$updatelatch = this.getUpdatelatch();
        ChronoLatch other$updatelatch = other.getUpdatelatch();
        if (this$updatelatch == null ? other$updatelatch != null : !this$updatelatch.equals(other$updatelatch)) {
            return false;
        }
        Notifier this$not = this.getNot();
        Notifier other$not = other.getNot();
        if (this$not == null ? other$not != null : !((Object)this$not).equals(other$not)) {
            return false;
        }
        Notifier this$actionBarNotifier = this.getActionBarNotifier();
        Notifier other$actionBarNotifier = other.getActionBarNotifier();
        if (this$actionBarNotifier == null ? other$actionBarNotifier != null : !((Object)this$actionBarNotifier).equals(other$actionBarNotifier)) {
            return false;
        }
        AdvancementHandler this$advancementHandler = this.getAdvancementHandler();
        AdvancementHandler other$advancementHandler = other.getAdvancementHandler();
        if (this$advancementHandler == null ? other$advancementHandler != null : !((Object)this$advancementHandler).equals(other$advancementHandler)) {
            return false;
        }
        if (Double.compare(this.getSpeed(), other.getSpeed()) != 0) {
            return false;
        }
        Vector this$velocity = this.getVelocity();
        Vector other$velocity = other.getVelocity();
        if (this$velocity == null ? other$velocity != null : !this$velocity.equals(other$velocity)) {
            return false;
        }
        Location this$lastpos = this.getLastpos();
        Location other$lastpos = other.getLastpos();
        return !(this$lastpos == null ? other$lastpos != null : !this$lastpos.equals(other$lastpos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaptPlayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastloc = this.getLastloc();
        result = result * 59 + (int)($lastloc >>> 32 ^ $lastloc);
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        PlayerData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        ChronoLatch $savelatch = this.getSavelatch();
        result = result * 59 + ($savelatch == null ? 43 : $savelatch.hashCode());
        ChronoLatch $updatelatch = this.getUpdatelatch();
        result = result * 59 + ($updatelatch == null ? 43 : $updatelatch.hashCode());
        Notifier $not = this.getNot();
        result = result * 59 + ($not == null ? 43 : ((Object)$not).hashCode());
        Notifier $actionBarNotifier = this.getActionBarNotifier();
        result = result * 59 + ($actionBarNotifier == null ? 43 : ((Object)$actionBarNotifier).hashCode());
        AdvancementHandler $advancementHandler = this.getAdvancementHandler();
        result = result * 59 + ($advancementHandler == null ? 43 : ((Object)$advancementHandler).hashCode());
        long $speed = Double.doubleToLongBits(this.getSpeed());
        result = result * 59 + (int)($speed >>> 32 ^ $speed);
        Vector $velocity = this.getVelocity();
        result = result * 59 + ($velocity == null ? 43 : $velocity.hashCode());
        Location $lastpos = this.getLastpos();
        result = result * 59 + ($lastpos == null ? 43 : $lastpos.hashCode());
        return result;
    }

    public Player getPlayer() {
        return this.player;
    }

    public PlayerData getData() {
        return this.data;
    }

    public ChronoLatch getSavelatch() {
        return this.savelatch;
    }

    public ChronoLatch getUpdatelatch() {
        return this.updatelatch;
    }

    public Notifier getNot() {
        return this.not;
    }

    public Notifier getActionBarNotifier() {
        return this.actionBarNotifier;
    }

    public AdvancementHandler getAdvancementHandler() {
        return this.advancementHandler;
    }

    public long getLastloc() {
        return this.lastloc;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public Location getLastpos() {
        return this.lastpos;
    }

    public void setSavelatch(ChronoLatch savelatch) {
        this.savelatch = savelatch;
    }

    public void setUpdatelatch(ChronoLatch updatelatch) {
        this.updatelatch = updatelatch;
    }

    public void setNot(Notifier not) {
        this.not = not;
    }

    public void setActionBarNotifier(Notifier actionBarNotifier) {
        this.actionBarNotifier = actionBarNotifier;
    }

    public void setAdvancementHandler(AdvancementHandler advancementHandler) {
        this.advancementHandler = advancementHandler;
    }

    public void setSpeed(RollingSequence speed) {
        this.speed = speed;
    }

    public void setLastloc(long lastloc) {
        this.lastloc = lastloc;
    }

    public void setVelocity(Vector velocity) {
        this.velocity = velocity;
    }

    public void setLastpos(Location lastpos) {
        this.lastpos = lastpos;
    }

    public String toString() {
        return "AdaptPlayer(player=" + this.getPlayer() + ", data=" + this.getData() + ", savelatch=" + this.getSavelatch() + ", updatelatch=" + this.getUpdatelatch() + ", not=" + this.getNot() + ", actionBarNotifier=" + this.getActionBarNotifier() + ", advancementHandler=" + this.getAdvancementHandler() + ", speed=" + this.getSpeed() + ", lastloc=" + this.getLastloc() + ", velocity=" + this.getVelocity() + ", lastpos=" + this.getLastpos() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

