/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.notification.ActionBarNotification;
import com.volmit.adapt.api.notification.SoundNotification;
import com.volmit.adapt.api.notification.TitleNotification;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.Discovery;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class PlayerData {
    private final Map<String, PlayerSkillLine> skillLines = new HashMap<String, PlayerSkillLine>();
    private Map<String, Double> stats = new HashMap<String, Double>();
    private String last = "none";
    private Set<String> advancements = new HashSet<String>();
    private Discovery<Biome> seenBiomes = new Discovery();
    private Discovery<EntityType> seenMobs = new Discovery();
    private Discovery<Material> seenFoods = new Discovery();
    private Discovery<Material> seenItems = new Discovery();
    private Discovery<String> seenRecipes = new Discovery();
    private Discovery<String> seenEnchants = new Discovery();
    private Discovery<String> seenWorlds = new Discovery();
    private Discovery<String> seenPeople = new Discovery();
    private Discovery<World.Environment> seenEnvironments = new Discovery();
    private Discovery<String> seenPotionEffects = new Discovery();
    private Discovery<String> seenBlocks = new Discovery();
    private List<XPMultiplier> multipliers = new ArrayList<XPMultiplier>();
    private long wisdom = 0L;
    private double multiplier = 0.0;
    private long lastLogin = 0L;
    private double masterXp = 1.0;
    private double lastMasterXp = 0.0;

    public void giveMasterXp(double xp) {
        this.masterXp += xp;
    }

    public void globalXPMultiplier(double v, int duration) {
        this.multipliers.add(new XPMultiplier(v, duration));
    }

    public boolean isGranted(String advancement) {
        return this.advancements.contains(advancement);
    }

    public void ensureGranted(String advancement) {
        this.advancements.add(advancement);
    }

    public double getStat(String key) {
        Double d = this.stats.get(key);
        return d == null ? 0.0 : d;
    }

    public void addStat(String key, double amt) {
        if (!this.stats.containsKey(key)) {
            this.stats.put(key, amt);
        } else {
            this.stats.put(key, this.stats.get(key) + amt);
        }
    }

    public void update(AdaptPlayer p) {
        int n;
        double m = 1.0;
        for (XPMultiplier xPMultiplier : XList.copy(this.multipliers)) {
            if (xPMultiplier.isExpired()) {
                this.multipliers.remove(xPMultiplier);
                continue;
            }
            m += xPMultiplier.getMultiplier();
        }
        for (XPMultiplier xPMultiplier : XList.copy(Adapt.instance.getAdaptServer().getData().getMultipliers())) {
            if (xPMultiplier.isExpired()) {
                Adapt.instance.getAdaptServer().getData().getMultipliers().remove(xPMultiplier);
                continue;
            }
            m += xPMultiplier.getMultiplier();
        }
        if (m <= 0.0) {
            m = 0.01;
        }
        if (m > 1000.0) {
            m = 1000.0;
        }
        this.multiplier = m;
        for (String string : XMap.k(this.skillLines)) {
            if (this.getSkillLine(string) == null) {
                this.skillLines.remove(string);
                Adapt.warn("Removed unknown skill line '" + string + "' from " + p.getPlayer().getName());
                continue;
            }
            if (this.getSkillLine(string).getXp() == 0.0 && this.getSkillLine(string).getKnowledge() == 0L) {
                this.skillLines.remove(string);
                continue;
            }
            this.getSkillLine(string).update(p, string, this);
        }
        int oldLevel = (int)XP.getLevelForXp(this.getLastMasterXp());
        if (oldLevel != (n = (int)XP.getLevelForXp(this.getMasterXp()))) {
            this.setLastMasterXp(this.getMasterXp());
            p.getNot().queue(SoundNotification.builder().sound(Sound.BLOCK_ENCHANTMENT_TABLE_USE).volume(1.0f).pitch(0.54f).group("lvl").build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(0.44f).group("lvl").build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(0.74f).group("lvl").build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(1.34f).group("lvl").build(), TitleNotification.builder().in(250L).stay(1450L).out(2250L).group("lvl").title("").subtitle(C.GOLD + "Level " + n).build());
            p.getActionBarNotifier().queue(ActionBarNotification.builder().duration(450L).group("power").title(C.GOLD + Form.f((double)n * AdaptConfig.get().getPowerPerLevel(), 0) + C.GRAY + " Maximum Ability Power").build());
        }
    }

    public int getAvailablePower() {
        return this.getMaxPower() - this.getUsedPower();
    }

    public boolean hasPowerAvailable() {
        return this.hasPowerAvailable(1);
    }

    public boolean hasPowerAvailable(int amount) {
        return this.getAvailablePower() >= amount;
    }

    public int getUsedPower() {
        return this.getSkillLines().values().stream().mapToInt(i -> i.getAdaptations().values().stream().mapToInt(PlayerAdaptation::getLevel).sum()).sum();
    }

    public int getLevel() {
        return (int)XP.getLevelForXp(this.getMasterXp());
    }

    public int getMaxPower() {
        return (int)(XP.getLevelForXp(this.getMasterXp()) * AdaptConfig.get().getPowerPerLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerSkillLine getSkillLine(String skillLine) {
        if (Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(skillLine) == null) {
            return null;
        }
        Map<String, PlayerSkillLine> map = this.skillLines;
        synchronized (map) {
            PlayerSkillLine s;
            try {
                s = this.skillLines.get(skillLine);
                if (s != null) {
                    return s;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                Adapt.error("Failed to get skill line " + skillLine);
            }
            s = new PlayerSkillLine();
            s.setLine(skillLine);
            this.skillLines.put(skillLine, s);
            return s;
        }
    }

    public void addWisdom() {
        ++this.wisdom;
    }

    public Map<String, PlayerSkillLine> getSkillLines() {
        return this.skillLines;
    }

    public Map<String, Double> getStats() {
        return this.stats;
    }

    public String getLast() {
        return this.last;
    }

    public Set<String> getAdvancements() {
        return this.advancements;
    }

    public Discovery<Biome> getSeenBiomes() {
        return this.seenBiomes;
    }

    public Discovery<EntityType> getSeenMobs() {
        return this.seenMobs;
    }

    public Discovery<Material> getSeenFoods() {
        return this.seenFoods;
    }

    public Discovery<Material> getSeenItems() {
        return this.seenItems;
    }

    public Discovery<String> getSeenRecipes() {
        return this.seenRecipes;
    }

    public Discovery<String> getSeenEnchants() {
        return this.seenEnchants;
    }

    public Discovery<String> getSeenWorlds() {
        return this.seenWorlds;
    }

    public Discovery<String> getSeenPeople() {
        return this.seenPeople;
    }

    public Discovery<World.Environment> getSeenEnvironments() {
        return this.seenEnvironments;
    }

    public Discovery<String> getSeenPotionEffects() {
        return this.seenPotionEffects;
    }

    public Discovery<String> getSeenBlocks() {
        return this.seenBlocks;
    }

    public List<XPMultiplier> getMultipliers() {
        return this.multipliers;
    }

    public long getWisdom() {
        return this.wisdom;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public double getMasterXp() {
        return this.masterXp;
    }

    public double getLastMasterXp() {
        return this.lastMasterXp;
    }

    public void setStats(Map<String, Double> stats) {
        this.stats = stats;
    }

    public void setLast(String last) {
        this.last = last;
    }

    public void setAdvancements(Set<String> advancements) {
        this.advancements = advancements;
    }

    public void setSeenBiomes(Discovery<Biome> seenBiomes) {
        this.seenBiomes = seenBiomes;
    }

    public void setSeenMobs(Discovery<EntityType> seenMobs) {
        this.seenMobs = seenMobs;
    }

    public void setSeenFoods(Discovery<Material> seenFoods) {
        this.seenFoods = seenFoods;
    }

    public void setSeenItems(Discovery<Material> seenItems) {
        this.seenItems = seenItems;
    }

    public void setSeenRecipes(Discovery<String> seenRecipes) {
        this.seenRecipes = seenRecipes;
    }

    public void setSeenEnchants(Discovery<String> seenEnchants) {
        this.seenEnchants = seenEnchants;
    }

    public void setSeenWorlds(Discovery<String> seenWorlds) {
        this.seenWorlds = seenWorlds;
    }

    public void setSeenPeople(Discovery<String> seenPeople) {
        this.seenPeople = seenPeople;
    }

    public void setSeenEnvironments(Discovery<World.Environment> seenEnvironments) {
        this.seenEnvironments = seenEnvironments;
    }

    public void setSeenPotionEffects(Discovery<String> seenPotionEffects) {
        this.seenPotionEffects = seenPotionEffects;
    }

    public void setSeenBlocks(Discovery<String> seenBlocks) {
        this.seenBlocks = seenBlocks;
    }

    public void setMultipliers(List<XPMultiplier> multipliers) {
        this.multipliers = multipliers;
    }

    public void setWisdom(long wisdom) {
        this.wisdom = wisdom;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void setMasterXp(double masterXp) {
        this.masterXp = masterXp;
    }

    public void setLastMasterXp(double lastMasterXp) {
        this.lastMasterXp = lastMasterXp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerData)) {
            return false;
        }
        PlayerData other = (PlayerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWisdom() != other.getWisdom()) {
            return false;
        }
        if (Double.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
            return false;
        }
        if (this.getLastLogin() != other.getLastLogin()) {
            return false;
        }
        if (Double.compare(this.getMasterXp(), other.getMasterXp()) != 0) {
            return false;
        }
        if (Double.compare(this.getLastMasterXp(), other.getLastMasterXp()) != 0) {
            return false;
        }
        Map<String, PlayerSkillLine> this$skillLines = this.getSkillLines();
        Map<String, PlayerSkillLine> other$skillLines = other.getSkillLines();
        if (this$skillLines == null ? other$skillLines != null : !((Object)this$skillLines).equals(other$skillLines)) {
            return false;
        }
        Map<String, Double> this$stats = this.getStats();
        Map<String, Double> other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats)) {
            return false;
        }
        String this$last = this.getLast();
        String other$last = other.getLast();
        if (this$last == null ? other$last != null : !this$last.equals(other$last)) {
            return false;
        }
        Set<String> this$advancements = this.getAdvancements();
        Set<String> other$advancements = other.getAdvancements();
        if (this$advancements == null ? other$advancements != null : !((Object)this$advancements).equals(other$advancements)) {
            return false;
        }
        Discovery<Biome> this$seenBiomes = this.getSeenBiomes();
        Discovery<Biome> other$seenBiomes = other.getSeenBiomes();
        if (this$seenBiomes == null ? other$seenBiomes != null : !this$seenBiomes.equals(other$seenBiomes)) {
            return false;
        }
        Discovery<EntityType> this$seenMobs = this.getSeenMobs();
        Discovery<EntityType> other$seenMobs = other.getSeenMobs();
        if (this$seenMobs == null ? other$seenMobs != null : !this$seenMobs.equals(other$seenMobs)) {
            return false;
        }
        Discovery<Material> this$seenFoods = this.getSeenFoods();
        Discovery<Material> other$seenFoods = other.getSeenFoods();
        if (this$seenFoods == null ? other$seenFoods != null : !this$seenFoods.equals(other$seenFoods)) {
            return false;
        }
        Discovery<Material> this$seenItems = this.getSeenItems();
        Discovery<Material> other$seenItems = other.getSeenItems();
        if (this$seenItems == null ? other$seenItems != null : !this$seenItems.equals(other$seenItems)) {
            return false;
        }
        Discovery<String> this$seenRecipes = this.getSeenRecipes();
        Discovery<String> other$seenRecipes = other.getSeenRecipes();
        if (this$seenRecipes == null ? other$seenRecipes != null : !this$seenRecipes.equals(other$seenRecipes)) {
            return false;
        }
        Discovery<String> this$seenEnchants = this.getSeenEnchants();
        Discovery<String> other$seenEnchants = other.getSeenEnchants();
        if (this$seenEnchants == null ? other$seenEnchants != null : !this$seenEnchants.equals(other$seenEnchants)) {
            return false;
        }
        Discovery<String> this$seenWorlds = this.getSeenWorlds();
        Discovery<String> other$seenWorlds = other.getSeenWorlds();
        if (this$seenWorlds == null ? other$seenWorlds != null : !this$seenWorlds.equals(other$seenWorlds)) {
            return false;
        }
        Discovery<String> this$seenPeople = this.getSeenPeople();
        Discovery<String> other$seenPeople = other.getSeenPeople();
        if (this$seenPeople == null ? other$seenPeople != null : !this$seenPeople.equals(other$seenPeople)) {
            return false;
        }
        Discovery<World.Environment> this$seenEnvironments = this.getSeenEnvironments();
        Discovery<World.Environment> other$seenEnvironments = other.getSeenEnvironments();
        if (this$seenEnvironments == null ? other$seenEnvironments != null : !this$seenEnvironments.equals(other$seenEnvironments)) {
            return false;
        }
        Discovery<String> this$seenPotionEffects = this.getSeenPotionEffects();
        Discovery<String> other$seenPotionEffects = other.getSeenPotionEffects();
        if (this$seenPotionEffects == null ? other$seenPotionEffects != null : !this$seenPotionEffects.equals(other$seenPotionEffects)) {
            return false;
        }
        Discovery<String> this$seenBlocks = this.getSeenBlocks();
        Discovery<String> other$seenBlocks = other.getSeenBlocks();
        if (this$seenBlocks == null ? other$seenBlocks != null : !this$seenBlocks.equals(other$seenBlocks)) {
            return false;
        }
        List<XPMultiplier> this$multipliers = this.getMultipliers();
        List<XPMultiplier> other$multipliers = other.getMultipliers();
        return !(this$multipliers == null ? other$multipliers != null : !((Object)this$multipliers).equals(other$multipliers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $wisdom = this.getWisdom();
        result = result * 59 + (int)($wisdom >>> 32 ^ $wisdom);
        long $multiplier = Double.doubleToLongBits(this.getMultiplier());
        result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
        long $lastLogin = this.getLastLogin();
        result = result * 59 + (int)($lastLogin >>> 32 ^ $lastLogin);
        long $masterXp = Double.doubleToLongBits(this.getMasterXp());
        result = result * 59 + (int)($masterXp >>> 32 ^ $masterXp);
        long $lastMasterXp = Double.doubleToLongBits(this.getLastMasterXp());
        result = result * 59 + (int)($lastMasterXp >>> 32 ^ $lastMasterXp);
        Map<String, PlayerSkillLine> $skillLines = this.getSkillLines();
        result = result * 59 + ($skillLines == null ? 43 : ((Object)$skillLines).hashCode());
        Map<String, Double> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        String $last = this.getLast();
        result = result * 59 + ($last == null ? 43 : $last.hashCode());
        Set<String> $advancements = this.getAdvancements();
        result = result * 59 + ($advancements == null ? 43 : ((Object)$advancements).hashCode());
        Discovery<Biome> $seenBiomes = this.getSeenBiomes();
        result = result * 59 + ($seenBiomes == null ? 43 : $seenBiomes.hashCode());
        Discovery<EntityType> $seenMobs = this.getSeenMobs();
        result = result * 59 + ($seenMobs == null ? 43 : $seenMobs.hashCode());
        Discovery<Material> $seenFoods = this.getSeenFoods();
        result = result * 59 + ($seenFoods == null ? 43 : $seenFoods.hashCode());
        Discovery<Material> $seenItems = this.getSeenItems();
        result = result * 59 + ($seenItems == null ? 43 : $seenItems.hashCode());
        Discovery<String> $seenRecipes = this.getSeenRecipes();
        result = result * 59 + ($seenRecipes == null ? 43 : $seenRecipes.hashCode());
        Discovery<String> $seenEnchants = this.getSeenEnchants();
        result = result * 59 + ($seenEnchants == null ? 43 : $seenEnchants.hashCode());
        Discovery<String> $seenWorlds = this.getSeenWorlds();
        result = result * 59 + ($seenWorlds == null ? 43 : $seenWorlds.hashCode());
        Discovery<String> $seenPeople = this.getSeenPeople();
        result = result * 59 + ($seenPeople == null ? 43 : $seenPeople.hashCode());
        Discovery<World.Environment> $seenEnvironments = this.getSeenEnvironments();
        result = result * 59 + ($seenEnvironments == null ? 43 : $seenEnvironments.hashCode());
        Discovery<String> $seenPotionEffects = this.getSeenPotionEffects();
        result = result * 59 + ($seenPotionEffects == null ? 43 : $seenPotionEffects.hashCode());
        Discovery<String> $seenBlocks = this.getSeenBlocks();
        result = result * 59 + ($seenBlocks == null ? 43 : $seenBlocks.hashCode());
        List<XPMultiplier> $multipliers = this.getMultipliers();
        result = result * 59 + ($multipliers == null ? 43 : ((Object)$multipliers).hashCode());
        return result;
    }

    public String toString() {
        return "PlayerData(skillLines=" + this.getSkillLines() + ", stats=" + this.getStats() + ", last=" + this.getLast() + ", advancements=" + this.getAdvancements() + ", seenBiomes=" + this.getSeenBiomes() + ", seenMobs=" + this.getSeenMobs() + ", seenFoods=" + this.getSeenFoods() + ", seenItems=" + this.getSeenItems() + ", seenRecipes=" + this.getSeenRecipes() + ", seenEnchants=" + this.getSeenEnchants() + ", seenWorlds=" + this.getSeenWorlds() + ", seenPeople=" + this.getSeenPeople() + ", seenEnvironments=" + this.getSeenEnvironments() + ", seenPotionEffects=" + this.getSeenPotionEffects() + ", seenBlocks=" + this.getSeenBlocks() + ", multipliers=" + this.getMultipliers() + ", wisdom=" + this.getWisdom() + ", multiplier=" + this.getMultiplier() + ", lastLogin=" + this.getLastLogin() + ", masterXp=" + this.getMasterXp() + ", lastMasterXp=" + this.getLastMasterXp() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

