/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.notification.ActionBarNotification;
import com.volmit.adapt.api.notification.Notifier;
import com.volmit.adapt.api.notification.SoundNotification;
import com.volmit.adapt.api.notification.TitleNotification;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Sound;

public class PlayerSkillLine {
    private String line = "";
    private double xp = 0.0;
    private double lastXP = 0.0;
    private long knowledge = 0L;
    private double multiplier = 1.0;
    private double freshness = 1.0;
    private double rfreshness = 1.0;
    private int lastLevel = 0;
    private long last = M.ms();
    private Map<String, Object> storage = new HashMap<String, Object>();
    private Map<String, PlayerAdaptation> adaptations = new HashMap<String, PlayerAdaptation>();
    private List<XPMultiplier> multipliers = new ArrayList<XPMultiplier>();

    private static double diff(long a, long b) {
        return Math.abs((double)a - (double)b / (double)(a == 0L ? 1L : a));
    }

    public void giveXP(Notifier p, double xp) {
        this.freshness -= xp * 0.001;
        xp = this.multiplier * xp;
        this.xp += xp;
        if (p != null) {
            this.last = M.ms();
            if (AdaptConfig.get().isActionbarNotifyXp()) {
                p.notifyXP(this.line, xp);
            }
        }
    }

    public void giveXPFresh(Notifier p, double xp) {
        xp = this.multiplier * xp;
        this.xp += xp;
        if (p != null) {
            this.last = M.ms();
            if (AdaptConfig.get().isActionbarNotifyXp()) {
                p.notifyXP(this.line, xp);
            }
        }
    }

    public boolean hasEarnedWithin(long ms) {
        return M.ms() - this.last < ms;
    }

    public PlayerAdaptation getAdaptation(String id) {
        return this.adaptations.get(id);
    }

    public int getAdaptationLevel(String id) {
        PlayerAdaptation a = this.getAdaptation(id);
        if (a == null) {
            return 0;
        }
        return a.getLevel();
    }

    public void setAdaptation(Adaptation a, int level) {
        if (level <= 1) {
            this.adaptations.remove(a.getName());
        }
        PlayerAdaptation v = new PlayerAdaptation();
        v.setId(a.getName());
        v.setLevel(Math.min(level, a.getMaxLevel()));
        this.adaptations.put(a.getName(), v);
    }

    public Skill getRawSkill(AdaptPlayer p) {
        return p.getServer().getSkillRegistry().getSkill(this.line);
    }

    public void update(AdaptPlayer p, String line, PlayerData data) {
        if (!p.getData().isGranted("skill_" + line) && AdaptConfig.get().isAdvancements()) {
            p.getAdvancementHandler().grant("skill_" + line);
        }
        for (String i : XMap.k(this.getAdaptations())) {
            if (p.getData().isGranted("adaptation_" + i) || !AdaptConfig.get().isAdvancements()) continue;
            p.getAdvancementHandler().grant("adaptation_" + i);
        }
        if (!p.isBusy() && this.getXp() > XP.getXpForLevel(AdaptConfig.get().experienceMaxLevel)) {
            p.getData().addWisdom();
            Adapt.warn("A Player has reached the maximum level of " + AdaptConfig.get().experienceMaxLevel + " and has been granted 1 wisdom, Dropping Level to " + this.lastLevel);
            this.setXp(XP.getXpForLevel(AdaptConfig.get().experienceMaxLevel - 1));
        }
        double max = 1.0 + (double)this.getLevel() * 0.004;
        this.freshness += 0.1 * this.freshness + 0.00124;
        if (this.freshness > max) {
            this.freshness = max;
        }
        if (this.freshness < 0.01) {
            this.freshness = 0.01;
        }
        if (this.freshness < this.rfreshness) {
            this.rfreshness -= (this.rfreshness - this.freshness) * 0.003;
        }
        if (this.freshness > this.rfreshness) {
            this.rfreshness += (this.freshness - this.rfreshness) * 0.265;
        }
        double m = this.rfreshness;
        for (XPMultiplier i : XList.copy(this.multipliers)) {
            if (i.isExpired()) {
                this.multipliers.remove(i);
                continue;
            }
            m += i.getMultiplier();
        }
        if (m <= 0.0) {
            m = 0.01;
        }
        if (m > 1000.0) {
            m = 1000.0;
        }
        this.multiplier = m * data.getMultiplier();
        double earned = this.xp - this.lastXP;
        if (earned > p.getServer().getSkillRegistry().getSkill(line).getMinXp()) {
            this.lastXP = this.xp;
        }
        if (this.lastLevel < this.getLevel()) {
            long kb = this.getKnowledge();
            for (int i = this.lastLevel; i < this.getLevel(); ++i) {
                this.giveKnowledge(i / 13 + 1);
                p.getData().giveMasterXp((double)i * AdaptConfig.get().getPlayerXpPerSkillLevelUpLevelMultiplier() + AdaptConfig.get().getPlayerXpPerSkillLevelUpBase());
            }
            if (AdaptConfig.get().isActionbarNotifyLevel()) {
                this.notifyLevel(p, this.getLevel(), this.getKnowledge());
            }
            this.lastLevel = this.getLevel();
        }
    }

    private void notifyLevel(AdaptPlayer p, double lvl, long kn) {
        if (lvl % 10.0 == 0.0) {
            p.getNot().queue(SoundNotification.builder().sound(Sound.UI_TOAST_CHALLENGE_COMPLETE).volume(1.0f).pitch(1.35f).group("lvl" + this.getLine()).build(), SoundNotification.builder().sound(Sound.UI_TOAST_CHALLENGE_COMPLETE).volume(1.0f).pitch(0.75f).group("lvl" + this.getLine()).build(), TitleNotification.builder().in(250L).stay(1450L).out(2250L).group("lvl" + this.getLine()).title("").subtitle(p.getServer().getSkillRegistry().getSkill(this.getLine()).getDisplayName(this.getLevel())).build());
            p.getActionBarNotifier().queue(ActionBarNotification.builder().duration(450L).group("know" + this.getLine()).title(kn + " " + p.getServer().getSkillRegistry().getSkill(this.getLine()).getShortName() + " Knowledge").build());
        } else {
            p.getActionBarNotifier().queue(SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_BREAK).volume(1.0f).pitch(1.74f).group("lvl" + this.getLine()).build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(0.74f).group("lvl" + this.getLine()).build(), ActionBarNotification.builder().duration(450L).group("lvl" + this.getLine()).title(p.getServer().getSkillRegistry().getSkill(this.getLine()).getDisplayName(this.getLevel())).build());
        }
        this.lastLevel = (int)Math.floor(XP.getLevelForXp(this.getXp()));
    }

    public void giveKnowledge(long points) {
        this.knowledge += points;
    }

    public double getMinimumXPForLevel() {
        return XP.getXpForLevel(this.getLevel());
    }

    public double getXPForLevelUpAbsolute() {
        return this.getMaximumXPForLevel() - this.getXp();
    }

    public double getXPForLevelUp() {
        return this.getMaximumXPForLevel() - this.getMinimumXPForLevel();
    }

    public double getMaximumXPForLevel() {
        return XP.getXpForLevel(this.getLevel());
    }

    public double getAbsoluteLevel() {
        return XP.getLevelForXp(this.xp);
    }

    public double getLevelProgress() {
        return this.getAbsoluteLevel() - (double)this.getLevel();
    }

    public double getLevelProgressRemaining() {
        return 1.0 - this.getLevelProgress();
    }

    public int getLevel() {
        return (int)Math.floor(this.getAbsoluteLevel());
    }

    public void boost(double v, int i) {
        this.multipliers.add(new XPMultiplier(v, i));
    }

    public boolean spendKnowledge(int c) {
        if (this.getKnowledge() >= (long)c) {
            this.setKnowledge(this.getKnowledge() - (long)c);
            return true;
        }
        return false;
    }

    public String getLine() {
        return this.line;
    }

    public double getXp() {
        return this.xp;
    }

    public double getLastXP() {
        return this.lastXP;
    }

    public long getKnowledge() {
        return this.knowledge;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getFreshness() {
        return this.freshness;
    }

    public double getRfreshness() {
        return this.rfreshness;
    }

    public int getLastLevel() {
        return this.lastLevel;
    }

    public long getLast() {
        return this.last;
    }

    public Map<String, Object> getStorage() {
        return this.storage;
    }

    public Map<String, PlayerAdaptation> getAdaptations() {
        return this.adaptations;
    }

    public List<XPMultiplier> getMultipliers() {
        return this.multipliers;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public void setXp(double xp) {
        this.xp = xp;
    }

    public void setLastXP(double lastXP) {
        this.lastXP = lastXP;
    }

    public void setKnowledge(long knowledge) {
        this.knowledge = knowledge;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setFreshness(double freshness) {
        this.freshness = freshness;
    }

    public void setRfreshness(double rfreshness) {
        this.rfreshness = rfreshness;
    }

    public void setLastLevel(int lastLevel) {
        this.lastLevel = lastLevel;
    }

    public void setLast(long last) {
        this.last = last;
    }

    public void setStorage(Map<String, Object> storage) {
        this.storage = storage;
    }

    public void setAdaptations(Map<String, PlayerAdaptation> adaptations) {
        this.adaptations = adaptations;
    }

    public void setMultipliers(List<XPMultiplier> multipliers) {
        this.multipliers = multipliers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerSkillLine)) {
            return false;
        }
        PlayerSkillLine other = (PlayerSkillLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getXp(), other.getXp()) != 0) {
            return false;
        }
        if (Double.compare(this.getLastXP(), other.getLastXP()) != 0) {
            return false;
        }
        if (this.getKnowledge() != other.getKnowledge()) {
            return false;
        }
        if (Double.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
            return false;
        }
        if (Double.compare(this.getFreshness(), other.getFreshness()) != 0) {
            return false;
        }
        if (Double.compare(this.getRfreshness(), other.getRfreshness()) != 0) {
            return false;
        }
        if (this.getLastLevel() != other.getLastLevel()) {
            return false;
        }
        if (this.getLast() != other.getLast()) {
            return false;
        }
        String this$line = this.getLine();
        String other$line = other.getLine();
        if (this$line == null ? other$line != null : !this$line.equals(other$line)) {
            return false;
        }
        Map<String, Object> this$storage = this.getStorage();
        Map<String, Object> other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        Map<String, PlayerAdaptation> this$adaptations = this.getAdaptations();
        Map<String, PlayerAdaptation> other$adaptations = other.getAdaptations();
        if (this$adaptations == null ? other$adaptations != null : !((Object)this$adaptations).equals(other$adaptations)) {
            return false;
        }
        List<XPMultiplier> this$multipliers = this.getMultipliers();
        List<XPMultiplier> other$multipliers = other.getMultipliers();
        return !(this$multipliers == null ? other$multipliers != null : !((Object)this$multipliers).equals(other$multipliers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerSkillLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $xp = Double.doubleToLongBits(this.getXp());
        result = result * 59 + (int)($xp >>> 32 ^ $xp);
        long $lastXP = Double.doubleToLongBits(this.getLastXP());
        result = result * 59 + (int)($lastXP >>> 32 ^ $lastXP);
        long $knowledge = this.getKnowledge();
        result = result * 59 + (int)($knowledge >>> 32 ^ $knowledge);
        long $multiplier = Double.doubleToLongBits(this.getMultiplier());
        result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
        long $freshness = Double.doubleToLongBits(this.getFreshness());
        result = result * 59 + (int)($freshness >>> 32 ^ $freshness);
        long $rfreshness = Double.doubleToLongBits(this.getRfreshness());
        result = result * 59 + (int)($rfreshness >>> 32 ^ $rfreshness);
        result = result * 59 + this.getLastLevel();
        long $last = this.getLast();
        result = result * 59 + (int)($last >>> 32 ^ $last);
        String $line = this.getLine();
        result = result * 59 + ($line == null ? 43 : $line.hashCode());
        Map<String, Object> $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        Map<String, PlayerAdaptation> $adaptations = this.getAdaptations();
        result = result * 59 + ($adaptations == null ? 43 : ((Object)$adaptations).hashCode());
        List<XPMultiplier> $multipliers = this.getMultipliers();
        result = result * 59 + ($multipliers == null ? 43 : ((Object)$multipliers).hashCode());
        return result;
    }

    public String toString() {
        return "PlayerSkillLine(line=" + this.getLine() + ", xp=" + this.getXp() + ", lastXP=" + this.getLastXP() + ", knowledge=" + this.getKnowledge() + ", multiplier=" + this.getMultiplier() + ", freshness=" + this.getFreshness() + ", rfreshness=" + this.getRfreshness() + ", lastLevel=" + this.getLastLevel() + ", last=" + this.getLast() + ", storage=" + this.getStorage() + ", adaptations=" + this.getAdaptations() + ", multipliers=" + this.getMultipliers() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

