/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.command.boost;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptServer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.command.FConst;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.github.mqzn.commands.annotations.base.Arg;
import io.github.mqzn.commands.annotations.base.Default;
import io.github.mqzn.commands.annotations.base.ExecutionMeta;
import io.github.mqzn.commands.annotations.base.Range;
import io.github.mqzn.commands.annotations.subcommands.SubCommandExecution;
import io.github.mqzn.commands.annotations.subcommands.SubCommandInfo;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@SubCommandInfo(name="boost")
@ExecutionMeta(description="Boost Target player, or Global Experience gain.", syntax="<seconds> <multiplier> [player]", permission="adapt.boost")
public final class CommandBoost {
    @Default
    public void info(CommandSender sender) {
        FConst.success(" --- === " + C.GRAY + "[" + C.DARK_RED + "Adapt Boost Help" + C.GRAY + "]:  === ---", new Object[0]);
        FConst.info("/adapt boost(this command)", new Object[0]).send(sender);
        FConst.info("/adapt boost <Seconds> <Multiplier> [player]", new Object[0]).send(sender);
        FConst.info(C.ITALIC + "The Multiplier is a Double, and if you dont specify a player its global", new Object[0]).send(sender);
    }

    @SubCommandExecution
    public void execute(CommandSender sender, @Arg(id="seconds") @Range(min="1", max="100000") int seconds, @Arg(id="multiplier") @Range(min="0.0", max="100.0") double multiplier, @Arg(id="player", optional=true) @Nullable Player player) {
        AdaptServer adaptServer = Adapt.instance.getAdaptServer();
        if (player == null) {
            adaptServer.boostXP(multiplier, seconds * 1000);
        } else {
            AdaptPlayer adaptPlayer = adaptServer.getPlayer(player);
            adaptPlayer.boostXPToRecents(multiplier, seconds * 1000);
        }
        FConst.success("Boosted XP by " + multiplier + " for " + seconds + " seconds", new Object[0]).send(sender);
    }

    static {
        IBootstrap.dasBoot();
    }
}

