/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.command.gui;

import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.skill.SkillRegistry;
import com.volmit.adapt.content.gui.SkillsGui;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.command.AdaptSuggestionProviderListing;
import com.volmit.adapt.util.command.FConst;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.github.mqzn.commands.annotations.base.Arg;
import io.github.mqzn.commands.annotations.base.Default;
import io.github.mqzn.commands.annotations.base.ExecutionMeta;
import io.github.mqzn.commands.annotations.base.Suggest;
import io.github.mqzn.commands.annotations.subcommands.SubCommandExecution;
import io.github.mqzn.commands.annotations.subcommands.SubCommandInfo;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@SubCommandInfo(name="gui")
@ExecutionMeta(permission="adapt.gui", description="Open the Adapt GUI", syntax="<guiTarget> [player] [force]")
public final class CommandGUI {
    @SubCommandExecution
    public void execute(CommandSender sender, @Arg(id="guiTarget") @Suggest(provider=AdaptSuggestionProviderListing.class) String guiTarget, @Arg(id="player", optional=true) @Nullable Player player, @Arg(id="force", optional=true, defaultValue="false") boolean force) {
        Player targetPlayer = player;
        boolean forceOpen = force;
        if (targetPlayer == null && sender instanceof ConsoleCommandSender) {
            FConst.error("You must specify a player when using this command from console.", new Object[0]).send(sender);
        } else if (targetPlayer == null) {
            targetPlayer = (Player)sender;
        }
        if (guiTarget.equals("[Main]")) {
            SkillsGui.open(targetPlayer);
            return;
        }
        if (guiTarget.startsWith("[Skill]")) {
            for (Skill<?> skill : XMap.sortV(SkillRegistry.skills)) {
                if (!guiTarget.equals("[Skill]" + skill.getName())) continue;
                if (forceOpen || skill.openGui(targetPlayer, true)) {
                    FConst.success("Opened GUI for " + skill.getName() + " for " + targetPlayer.getName(), new Object[0]).send(sender);
                } else {
                    FConst.error("Failed to open GUI for " + skill.getName() + " for " + targetPlayer.getName() + " - No Permission, remove from blacklist!", new Object[0]).send(sender);
                }
                return;
            }
        }
        if (guiTarget.startsWith("[Adaptation]")) {
            for (Skill<?> skill : XMap.sortV(SkillRegistry.skills)) {
                for (Adaptation<?> adaptation : skill.getAdaptations()) {
                    if (!guiTarget.equals("[Adaptation]" + adaptation.getName())) continue;
                    if (forceOpen || adaptation.openGui(targetPlayer, true)) {
                        FConst.success("Opened GUI for " + adaptation.getName() + " for " + targetPlayer.getName(), new Object[0]).send(sender);
                    } else {
                        FConst.error("Failed to open GUI for " + adaptation.getName() + " for " + targetPlayer.getName() + " - No Permission, remove from blacklist!", new Object[0]).send(sender);
                    }
                    return;
                }
            }
        }
        this.info(sender);
    }

    @Default
    public void info(CommandSender sender) {
        FConst.success(" --- === " + C.GRAY + "[" + C.DARK_RED + "Adapt GUI Help" + C.GRAY + "]:  === ---", new Object[0]).send(sender);
        FConst.info("/adapt gui (this command)", new Object[0]).send(sender);
        FConst.info("/adapt gui <GUI-Target>", new Object[0]).send(sender);
        FConst.info("/adapt gui <GUI-Target> [Player] [Force]", new Object[0]).send(sender);
    }

    static {
        IBootstrap.dasBoot();
    }
}

