/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.command.item;

import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.skill.SkillRegistry;
import com.volmit.adapt.content.item.ExperienceOrb;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.command.AdaptSuggestionProvider;
import com.volmit.adapt.util.command.FConst;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.github.mqzn.commands.annotations.base.Arg;
import io.github.mqzn.commands.annotations.base.Default;
import io.github.mqzn.commands.annotations.base.ExecutionMeta;
import io.github.mqzn.commands.annotations.base.Range;
import io.github.mqzn.commands.annotations.base.Suggest;
import io.github.mqzn.commands.annotations.subcommands.SubCommandExecution;
import io.github.mqzn.commands.annotations.subcommands.SubCommandInfo;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@SubCommandInfo(name="experience")
@ExecutionMeta(description="Give yourself an experience orb", syntax="<skillname> <amount> [player]", permission="adapt.cheatitem")
public final class CommandExperience {
    @SubCommandExecution
    public void execute(CommandSender sender, @Arg(id="skillname") @Suggest(provider=AdaptSuggestionProvider.class) String skillName, @Arg(id="amount") @Range(min="1", max="100000") int amount, @Arg(id="player", optional=true) @Nullable Player player) {
        Player targetPlayer = player;
        if (targetPlayer == null) {
            if (sender instanceof Player) {
                Player p = (Player)sender;
                targetPlayer = p;
            } else {
                FConst.error("You must be a player to use this command, or Reference a player", new Object[0]).send(sender);
                return;
            }
        }
        if (skillName.equals("[all]")) {
            for (Skill skill : XMap.sortV(SkillRegistry.skills)) {
                targetPlayer.getInventory().addItem(new ItemStack[]{ExperienceOrb.with(skill.getName(), amount)});
            }
            FConst.success("Giving all orbs", new Object[0]).send(sender);
            return;
        }
        if (skillName.equals("[random]")) {
            targetPlayer.getInventory().addItem(new ItemStack[]{ExperienceOrb.with(XList.getRandom(XMap.sortV(SkillRegistry.skills)).getName(), amount)});
            FConst.success("Giving random orb", new Object[0]).send(sender);
            return;
        }
        Skill<?> skill = SkillRegistry.skills.get(skillName);
        if (skill != null) {
            targetPlayer.getInventory().addItem(new ItemStack[]{ExperienceOrb.with(skill.getName(), amount)});
            FConst.success("Giving " + skill.getName() + " orb", new Object[0]).send(sender);
        }
    }

    @Default
    public void info(CommandSender sender) {
        FConst.success(" --- === " + C.GRAY + "[" + C.DARK_RED + "Adapt Item Help" + C.GRAY + "]:  === ---", new Object[0]);
        FConst.info("/adapt item (this command)", new Object[0]).send(sender);
        FConst.info("/adapt item experience <Skill> <Amount> [Player]", new Object[0]).send(sender);
        FConst.info("/adapt item knowledge <Skill> <Amount> [Player]", new Object[0]).send(sender);
    }

    static {
        IBootstrap.dasBoot();
    }
}

