/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.architect;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.adaptation.chunk.ChunkLoading;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.content.item.BoundRedstoneTorch;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ArchitectWirelessRedstone
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public ArchitectWirelessRedstone() {
        super("architect-wireless-redstone");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("architect", "wirelessredstone", "description"));
        this.setDisplayName(Localizer.dLocalize("architect", "wirelessredstone", "name"));
        this.setIcon(Material.REDSTONE_TORCH);
        this.setInterval(100L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.registerRecipe(AdaptRecipe.shapeless().key("remote-redstone-torch").ingredient(Material.REDSTONE_TORCH).ingredient(Material.TARGET).ingredient(Material.ENDER_PEARL).result(BoundRedstoneTorch.io.withData(new BoundRedstoneTorch.Data(null))).build());
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("architect", "wirelessredstone", "lore1"));
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (this.isRedstoneTorch(mainHand)) {
            this.updateTorchCooldown(player, mainHand);
        }
        if (this.isRedstoneTorch(offHand)) {
            this.updateTorchCooldown(player, offHand);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean offHandBound;
        Player player = event.getPlayer();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        boolean mainHandBound = this.isRedstoneTorch(mainHand) && this.isBound(mainHand);
        boolean bl = offHandBound = this.isRedstoneTorch(offHand) && this.isBound(offHand);
        if (this.shouldCancelEvent(player, event, mainHandBound, offHandBound)) {
            event.setCancelled(true);
            return;
        }
        this.handleOffhandInteraction(event, player);
        if (mainHandBound) {
            this.handleRedstoneTorchInteraction(event, player, mainHand);
        }
    }

    private boolean shouldCancelEvent(Player player, PlayerInteractEvent event, boolean mainHandBound, boolean offHandBound) {
        boolean blockPlacementAction;
        boolean hasAdaptation = this.hasAdaptation(player);
        boolean canUseInCreative = AdaptConfig.get().allowAdaptationsInCreative;
        boolean isCreative = player.getGameMode() == GameMode.CREATIVE;
        boolean bl = blockPlacementAction = event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getHand() == EquipmentSlot.HAND;
        if ((mainHandBound || offHandBound) && (!hasAdaptation && !isCreative || hasAdaptation && !canUseInCreative && isCreative)) {
            return blockPlacementAction || hasAdaptation && !isCreative;
        }
        return false;
    }

    private boolean isRedstoneTorch(ItemStack item) {
        return item.getType().equals((Object)Material.REDSTONE_TORCH);
    }

    private void updateTorchCooldown(Player player, ItemStack mainHand) {
        int cooldown = this.isBound(mainHand) ? 50000 : 0;
        player.setCooldown(Material.REDSTONE_TORCH, cooldown);
    }

    private void handleOffhandInteraction(PlayerInteractEvent event, Player player) {
        ItemStack offhand = player.getInventory().getItemInOffHand();
        if (event.getHand() != null && event.getHand().equals((Object)EquipmentSlot.OFF_HAND) && BoundRedstoneTorch.isBindableItem(offhand)) {
            event.setCancelled(true);
        }
    }

    private void handleRedstoneTorchInteraction(PlayerInteractEvent event, Player player, ItemStack mainHand) {
        if (BoundRedstoneTorch.isBindableItem(mainHand)) {
            if (!this.hasAdaptation(player)) {
                return;
            }
            Adapt.verbose("Player " + player.getName() + " is holding a bound redstone torch");
            switch (event.getAction()) {
                case LEFT_CLICK_BLOCK: {
                    this.handleLeftClickBlock(event, player);
                    break;
                }
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    this.handleRightClickBlock(event, player);
                }
            }
        }
    }

    private void handleLeftClickBlock(PlayerInteractEvent event, Player player) {
        Adapt.verbose("Player " + player.getName() + " is left clicking a block");
        if (player.isSneaking()) {
            if (event.getClickedBlock() == null) {
                player.playSound(player.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 0.1f, 0.9f);
                return;
            }
            Location location = new Location(event.getClickedBlock().getWorld(), (double)event.getClickedBlock().getX(), (double)event.getClickedBlock().getY(), (double)event.getClickedBlock().getZ());
            event.setCancelled(true);
            this.linkTorch(player, location);
        } else {
            event.setCancelled(false);
        }
    }

    private void handleRightClickBlock(PlayerInteractEvent event, Player player) {
        Adapt.verbose("Player " + player.getName() + " is right clicking a block");
        if (this.hasCooldown(player)) {
            player.playSound(player.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 0.1f, 0.9f);
        } else {
            this.cooldowns.put(player, System.currentTimeMillis() + (long)((Config)this.getConfig()).cooldown);
            this.triggerPulse(player);
            event.setCancelled(true);
        }
    }

    private boolean hasCooldown(Player i) {
        if (this.cooldowns.containsKey(i) && M.ms() >= this.cooldowns.get(i)) {
            this.cooldowns.remove(i);
        }
        return this.cooldowns.containsKey(i);
    }

    private void linkTorch(Player p, Location l) {
        if (!l.getBlock().getType().equals((Object)Material.TARGET)) {
            return;
        }
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(l.getBlock(), l.getBlock(), Color.RED, 1);
        }
        p.getWorld().playSound(l, Sound.BLOCK_CHEST_OPEN, 0.1f, 9.0f);
        p.getWorld().playSound(l, Sound.ENTITY_ENDER_EYE_DEATH, 0.2f, 0.48f);
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (hand.getAmount() == 1) {
            BoundRedstoneTorch.setData(hand, l);
        } else {
            hand.setAmount(hand.getAmount() - 1);
            ItemStack torch = BoundRedstoneTorch.withData(l);
            p.getInventory().addItem(new ItemStack[]{torch}).values().forEach(i -> p.getWorld().dropItemNaturally(p.getLocation(), i));
        }
    }

    private void triggerPulse(Player p) {
        Location l = BoundRedstoneTorch.getLocation(p.getInventory().getItemInMainHand());
        if (this.isBound(p.getInventory().getItemInMainHand()) && l != null) {
            ChunkLoading.loadChunkAsync(l, chunk -> {
                Block b = l.getBlock();
                BlockData data = b.getBlockData();
                if (data instanceof AnaloguePowerable) {
                    AnaloguePowerable redBlock = (AnaloguePowerable)data;
                    if (b.getType().equals((Object)Material.TARGET)) {
                        p.getWorld().playSound(l, Sound.BLOCK_CHEST_OPEN, 0.1f, 9.0f);
                        redBlock.setPower(15);
                        this.vfxCuboidOutline(l.getBlock(), l.getBlock(), Color.RED, 1);
                        b.setBlockData((BlockData)redBlock);
                        J.s(() -> {
                            redBlock.setPower(0);
                            b.setBlockData((BlockData)redBlock);
                        }, 2);
                        return;
                    }
                }
                p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 0.1f, 0.9f);
            });
        }
    }

    private boolean isBound(ItemStack stack) {
        return stack.getType().equals((Object)Material.REDSTONE_TORCH) && BoundRedstoneTorch.getLocation(stack) != null;
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            ItemStack hand = p.getInventory().getItemInMainHand();
            ItemStack offhand = p.getInventory().getItemInOffHand();
            if (!this.isBound(hand)) {
                J.s(() -> p.setCooldown(Material.REDSTONE_TORCH, 0));
                continue;
            }
            J.s(() -> p.setCooldown(Material.REDSTONE_TORCH, 50000));
        }
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int cooldown = 125;
        boolean permanent = true;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 1;
        int initialCost = 0;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

