/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.brewing;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.content.matter.BrewingStandOwner;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;

public class BrewingSuperHeated
extends SimpleAdaptation<Config> {
    private static final int MAX_CHECKS_BEFORE_REMOVE = 20;
    private final Map<Block, Integer> activeStands = new HashMap<Block, Integer>();

    public BrewingSuperHeated() {
        super("brewing-super-heated");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("brewing", "superheated", "description"));
        this.setDisplayName(Localizer.dLocalize("brewing", "superheated", "name"));
        this.setIcon(Material.LAVA_BUCKET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(253L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getFireBoost(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "superheated", "lore1"));
        v.addLore(C.GREEN + "+ " + Form.pc(this.getLavaBoost(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "superheated", "lore2"));
    }

    public double getLavaBoost(double factor) {
        return ((Config)this.getConfig()).lavaMultiplier * (((Config)this.getConfig()).multiplierFactor * factor);
    }

    public double getFireBoost(double factor) {
        return ((Config)this.getConfig()).fireMultiplier * (((Config)this.getConfig()).multiplierFactor * factor);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryMoveItemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        J.s(() -> {
            if (e.getDestination().getType().equals((Object)InventoryType.BREWING)) {
                this.activeStands.put(e.getDestination().getLocation().getBlock(), 20);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BrewEvent e) {
        if (e.isCancelled()) {
            return;
        }
        J.s(() -> {
            if (((BrewingStand)e.getBlock().getState()).getBrewingTime() > 0) {
                this.activeStands.put(e.getBlock(), 20);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent e) {
        if (e.getClickedInventory() == null || e.isCancelled()) {
            return;
        }
        if (e.getView().getTopInventory().getType().equals((Object)InventoryType.BREWING)) {
            this.activeStands.put(e.getView().getTopInventory().getLocation().getBlock(), 20);
        }
    }

    @Override
    public void onTick() {
        if (this.activeStands.isEmpty()) {
            return;
        }
        Iterator<Block> it = this.activeStands.keySet().iterator();
        J.s(() -> {
            while (it.hasNext()) {
                BlockState s = ((Block)it.next()).getState();
                if (s instanceof BrewingStand) {
                    BrewingStand b = (BrewingStand)s;
                    if (b.getBrewingTime() <= 0) {
                        J.s(() -> {
                            BrewingStand bb = (BrewingStand)s.getBlock().getState();
                            if (bb.getBrewingTime() <= 0) {
                                if (this.activeStands.get(b.getBlock()) == 0) {
                                    this.activeStands.remove(b.getBlock());
                                }
                                if (this.activeStands.containsKey(b.getBlock())) {
                                    this.activeStands.put(b.getBlock(), this.activeStands.get(b.getBlock()) - 1);
                                }
                            }
                        });
                        continue;
                    }
                    BrewingStandOwner owner = WorldData.of(b.getWorld()).getMantle().get(b.getX(), b.getY(), b.getZ(), BrewingStandOwner.class);
                    if (owner == null) {
                        it.remove();
                        continue;
                    }
                    PlayerData p = this.getServer().peekData(owner.getOwner());
                    if (p.getSkillLines().get(this.getSkill().getName()) != null && p.getSkillLines().get(this.getSkill().getName()).getAdaptations().containsKey(this.getName()) && p.getSkillLines().get(this.getSkill().getName()).getAdaptations().get(this.getName()).getLevel() > 0) {
                        this.updateHeat(b, this.getLevelPercent(p.getSkillLines().get(this.getSkill().getName()).getAdaptations().get(this.getName()).getLevel()));
                        continue;
                    }
                    it.remove();
                    continue;
                }
                it.remove();
            }
        });
    }

    private void updateHeat(BrewingStand b, double factor) {
        double l = 0.0;
        double f = 0.0;
        switch (b.getBlock().getRelative(BlockFace.DOWN).getType()) {
            case LAVA: {
                l += 1.0;
                break;
            }
            case FIRE: {
                f += 1.0;
            }
        }
        switch (b.getBlock().getRelative(BlockFace.NORTH).getType()) {
            case LAVA: {
                l += 1.0;
                break;
            }
            case FIRE: {
                f += 1.0;
            }
        }
        switch (b.getBlock().getRelative(BlockFace.SOUTH).getType()) {
            case LAVA: {
                l += 1.0;
                break;
            }
            case FIRE: {
                f += 1.0;
            }
        }
        switch (b.getBlock().getRelative(BlockFace.EAST).getType()) {
            case LAVA: {
                l += 1.0;
                break;
            }
            case FIRE: {
                f += 1.0;
            }
        }
        switch (b.getBlock().getRelative(BlockFace.WEST).getType()) {
            case LAVA: {
                l += 1.0;
                break;
            }
            case FIRE: {
                f += 1.0;
            }
        }
        double pct = this.getFireBoost(factor) * f + this.getLavaBoost(factor) * l + 1.0;
        int warp = (int)((double)this.getInterval() / 50.0 * pct);
        b.setBrewingTime(Math.max(1, b.getBrewingTime() - warp));
        b.update();
        if (M.r(1.0 / (333.0 / (double)this.getInterval()))) {
            b.getBlock().getWorld().playSound(b.getBlock().getLocation(), Sound.BLOCK_FIRE_AMBIENT, 1.0f, 1.0f + RNG.r.f(0.3f, 0.6f));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        double costFactor = 0.75;
        int maxLevel = 5;
        int initialCost = 5;
        double multiplierFactor = 1.33;
        double fireMultiplier = 0.14;
        double lavaMultiplier = 0.69;

        static {
            IBootstrap.dasBoot();
        }
    }
}

